/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.backup.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.jcr.Item;
import javax.jcr.PathNotFoundException;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.backup.IModelBackupService;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.modeshape.jcr.api.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultModelBackupService
implements IModelBackupService {
    @Autowired
    private javax.jcr.Session session;
    @Autowired
    private IModelRepository modelRepository;

    @Override
    public byte[] backup() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ((Session)this.session).exportDocumentView("/", (OutputStream)baos, false, false);
        baos.close();
        return baos.toByteArray();
    }

    @Override
    public void restore(byte[] backup) throws Exception {
        this.removeAll();
        ((Session)this.session).getWorkspace().importXML("/", (InputStream)new ByteArrayInputStream(backup), 0);
    }

    public javax.jcr.Session getSession() {
        return this.session;
    }

    public void setSession(javax.jcr.Session session) {
        this.session = session;
    }

    public IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public void setModelRepository(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    private void removeAll() throws Exception {
        HashSet<String> rootNodes = new HashSet<String>();
        for (ModelInfo resource : this.modelRepository.search("*")) {
            int namespaceIdx = resource.getId().getNamespace().indexOf(".");
            if (namespaceIdx != -1) {
                String org = resource.getId().getNamespace().substring(0, namespaceIdx);
                rootNodes.add(org);
                continue;
            }
            rootNodes.add(resource.getId().getNamespace());
        }
        for (String rootNode : rootNodes) {
            try {
                Item item = this.session.getItem("/" + rootNode);
                item.remove();
            }
            catch (PathNotFoundException pathNotFoundException) {}
        }
        this.session.save();
    }
}

