/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.account.impl;

import java.sql.Timestamp;
import java.util.Arrays;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.account.Role;
import org.eclipse.vorto.repository.account.UserUtils;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DefaultUserAccountService
implements IUserAccountService {
    private static final String USER_ANONYMOUS = "anonymous";
    @Value(value="${server.admin:#{null}}")
    private String admins;
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private IModelRepository modelRepository;

    @Override
    public void create(String username) {
        User user = new User();
        user.setUsername(username);
        user.setDateCreated(new Timestamp(System.currentTimeMillis()));
        user.setLastUpdated(new Timestamp(System.currentTimeMillis()));
        user.setAckOfTermsAndCondTimestamp(new Timestamp(System.currentTimeMillis()));
        user.setRole(this.toRole(username));
        user = (User)this.userRepository.save(user);
        if (user != null) {
            UserUtils.refreshSpringSecurityUser(user);
        }
    }

    private Role toRole(String username) {
        if (this.admins != null && Arrays.asList(this.admins.split(";")).contains(username)) {
            return Role.ADMIN;
        }
        return Role.USER;
    }

    @Override
    public void delete(String userId) {
        User userToDelete = this.userRepository.findByUsername(userId);
        if (userToDelete != null) {
            this.userRepository.delete(userToDelete);
        }
    }

    public IUserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(IUserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public void setModelRepository(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    @Override
    public boolean exists(String userId) {
        return this.userRepository.findByUsername(userId) != null;
    }
}

