/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.security;

import java.io.Serializable;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;

public class IsModelAuthorEvaluator
implements PermissionEvaluator {
    private IModelRepository repository;

    public IsModelAuthorEvaluator(IModelRepository repository) {
        this.repository = repository;
    }

    public IsModelAuthorEvaluator() {
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        String callerId = authentication.getName();
        if (targetDomainObject instanceof ModelId) {
            ModelInfo modelInfo = this.repository.getById((ModelId)targetDomainObject);
            if (modelInfo != null) {
                return modelInfo.getAuthor().equalsIgnoreCase(callerId);
            }
        } else if (targetDomainObject instanceof String) {
            return callerId.equalsIgnoreCase((String)targetDomainObject);
        }
        return false;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        return false;
    }
}

