/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.core;

import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.upload.ModelHandle;
import org.eclipse.vorto.repository.api.upload.UploadModelResponse;
import org.eclipse.vorto.repository.api.upload.UploadModelResult;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.ITemporaryStorage;
import org.eclipse.vorto.repository.core.impl.utils.BulkUploadHelper;
import org.eclipse.vorto.repository.web.core.exceptions.UploadTooLargeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="/share", description="Upload information models")
@RestController
@RequestMapping(value={"/rest/secure"})
public class ShareModelController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final String ERROR_MSG_FORMAT = "Models cannot be checked in because there {0,choice,1#is|1<are} {0} {0,choice,1#model|1<models} with {0,choice,1#error|1<errors}.";
    private final String SUCCESS_MSG_FORMAT = "{0,choice,1#The uploaded model is|1<All uploaded models are} valid and ready to check in.";
    @Autowired
    private IModelRepository modelRepository;
    @Autowired
    private ITemporaryStorage uploadStorage;
    @Value(value="${server.config.maxModelSize}")
    private long maxModelSize;
    private UploadModelResult uploadModelResult;

    @ApiOperation(value="Upload and validate a single vorto model")
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<UploadModelResponse> uploadModel(@ApiParam(value="The vorto model file to upload", required=true) @RequestParam(value="file") MultipartFile file) {
        if (file.getSize() > this.maxModelSize) {
            throw new UploadTooLargeException("model", this.maxModelSize);
        }
        this.LOGGER.info("uploadModel: [" + file.getOriginalFilename() + "]");
        try {
            this.uploadModelResult = this.modelRepository.upload(file.getBytes(), file.getOriginalFilename(), SecurityContextHolder.getContext().getAuthentication().getName());
            ArrayList uploadModelResults = Lists.newArrayList();
            uploadModelResults.add(this.uploadModelResult);
            String message = "Uploaded model " + file.getOriginalFilename() + (this.uploadModelResult.isValid() ? " is valid to check in." : " has errors. Cannot check in.");
            return this.validResponse(new UploadModelResponse(message, Boolean.valueOf(this.uploadModelResult.isValid()), (List)uploadModelResults));
        }
        catch (IOException e) {
            this.LOGGER.error("Error upload model." + e.getStackTrace());
            UploadModelResponse errorResponse = new UploadModelResponse("Error during upload. Try again. " + e.getMessage(), Boolean.valueOf(false), null);
            return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Upload and validate multiple vorto models")
    @RequestMapping(value={"multiple"}, method={RequestMethod.POST})
    public ResponseEntity<UploadModelResponse> uploadMultipleModels(@ApiParam(value="The vorto model files to upload", required=true) @RequestParam(value="file") MultipartFile file) {
        if (file.getSize() > this.maxModelSize) {
            throw new UploadTooLargeException("model", this.maxModelSize);
        }
        this.LOGGER.info("Bulk upload Models: [" + file.getOriginalFilename() + "]");
        try {
            BulkUploadHelper bulkUploadService = new BulkUploadHelper(this.modelRepository, this.uploadStorage);
            List<UploadModelResult> uploadModelResults = bulkUploadService.uploadMultiple(file.getBytes(), file.getOriginalFilename(), SecurityContextHolder.getContext().getAuthentication().getName());
            this.LOGGER.info("Models Uploaded: [" + uploadModelResults.size() + "]");
            UploadModelResponse serverResponse = uploadModelResults.size() == 0 ? new UploadModelResponse("Uploaded file doesn't have any valid models.", Boolean.valueOf(false), uploadModelResults) : this.createModelResponse(uploadModelResults);
            return this.validResponse(serverResponse);
        }
        catch (Exception e) {
            this.LOGGER.error("Error bulk upload models.", (Throwable)e);
            return this.erroredResponse("Error during upload. Try again. " + e.getMessage());
        }
    }

    @ApiOperation(value="Checkin an uploaded vorto model into the repository")
    @RequestMapping(value={"/{handleId:.+}"}, method={RequestMethod.PUT})
    public ResponseEntity<ModelId> checkin(@ApiParam(value="The file name of uploaded vorto model", required=true) @PathVariable String handleId) {
        this.LOGGER.info("Check in Model " + handleId);
        try {
            ModelInfo result = this.modelRepository.checkin(handleId, SecurityContextHolder.getContext().getAuthentication().getName());
            return new ResponseEntity((Object)result.getId(), HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOGGER.error("Error checkin model. " + handleId, (Throwable)e);
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    @ApiOperation(value="Checkin multiple uploaded vorto models into the  repository")
    @RequestMapping(value={"/checkInMultiple"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> checkInMultiple(@ApiParam(value="The file name of uploaded vorto model", required=true) @RequestBody ModelHandle[] modelHandles) {
        this.LOGGER.info("Bulk check in models.");
        try {
            for (ModelHandle handle : modelHandles) {
                this.modelRepository.checkin(handle.getHandleId(), SecurityContextHolder.getContext().getAuthentication().getName());
            }
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOGGER.error("Error bulk checkin models.", (Throwable)e);
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    private ResponseEntity<UploadModelResponse> validResponse(UploadModelResponse successModelResponse) {
        return new ResponseEntity((Object)successModelResponse, HttpStatus.OK);
    }

    private ResponseEntity<UploadModelResponse> erroredResponse(String errorMessage) {
        UploadModelResponse errorResponse = new UploadModelResponse("Error during checkin. Try again. " + errorMessage, Boolean.valueOf(false), null);
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private UploadModelResponse createModelResponse(List<UploadModelResult> uploadModelResults) {
        if (uploadModelResults.size() == 0) {
            return new UploadModelResponse("No valid models found. Nothing to checkin", Boolean.valueOf(false), null);
        }
        long noOfInvalidModels = uploadModelResults.stream().filter(result -> !result.isValid()).count();
        return noOfInvalidModels > 0L ? new UploadModelResponse(this.resolveMessage("Models cannot be checked in because there {0,choice,1#is|1<are} {0} {0,choice,1#model|1<models} with {0,choice,1#error|1<errors}.", noOfInvalidModels), Boolean.valueOf(false), uploadModelResults) : new UploadModelResponse(this.resolveMessage("{0,choice,1#The uploaded model is|1<All uploaded models are} valid and ready to check in.", uploadModelResults.size()), Boolean.valueOf(true), uploadModelResults);
    }

    private String resolveMessage(String messageFormat, long occurences) {
        return MessageFormat.format(messageFormat, occurences);
    }
}

