/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.backup;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.backup.IModelBackupService;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.eclipse.vorto.repository.web.core.exceptions.UploadTooLargeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/admin"})
public class BackupController
extends AbstractRepositoryController {
    @Autowired
    private IModelBackupService backupService;
    @Autowired
    private IModelRepository repositoryService;
    @Value(value="${server.config.maxBackupSize}")
    private long maxBackupSize;
    private static final String ATTACHMENT_FILENAME = "attachment; filename = ";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final SimpleDateFormat SIMPLEDATEFORMAT = new SimpleDateFormat("yyyyMMdd-HH:mm");

    @RequestMapping(value={"/{namespace}/{name}/{version:.+}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(new org.eclipse.vorto.repository.api.ModelId(#name,#namespace,#version),'model:delete')")
    public void deleteModelResource(@PathVariable String namespace, @PathVariable String name, @PathVariable String version) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        this.repositoryService.removeModel(new ModelId(name, namespace, version));
    }

    @RequestMapping(value={"/content"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void backupRepository(HttpServletResponse response) throws Exception {
        byte[] backup = this.backupService.backup();
        response.setHeader(CONTENT_DISPOSITION, "attachment; filename = vortobackup_" + SIMPLEDATEFORMAT.format(new Date()) + ".xml");
        response.setContentLengthLong((long)backup.length);
        response.setContentType(APPLICATION_OCTET_STREAM);
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(backup), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying file.", e);
        }
    }

    @RequestMapping(value={"/content"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void restoreRepository(@RequestParam(value="file") MultipartFile file) throws Exception {
        if (file.getSize() > this.maxBackupSize) {
            throw new UploadTooLargeException("backup", this.maxBackupSize);
        }
        this.backupService.restore(file.getBytes());
    }
}

