/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.account;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.security.Principal;
import java.sql.Timestamp;
import javax.validation.Valid;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.account.UserAccount;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.web.account.UserDto;
import org.eclipse.vorto.repository.web.account.UserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="User Controller", description="REST API to manage user accounts")
@RestController
@RequestMapping(value={"/rest"})
public class UserController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private IUserAccountService accountService;
    @Autowired(required=false)
    private PasswordEncoder passwordEncoder;

    @ApiOperation(value="Returns a specified User")
    @ApiResponses(value={@ApiResponse(code=404, message="Not found"), @ApiResponse(code=200, message="OK")})
    @RequestMapping(method={RequestMethod.GET}, value={"/users/{username:.+}"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or #username == authentication.name")
    public ResponseEntity<UserDto> getUser(@ApiParam(value="Username", required=true) @PathVariable String username) {
        this.LOGGER.debug("User {} - {} ", (Object)username, (Object)this.userRepository.findByUsername(username));
        return new ResponseEntity((Object)UserDto.fromUser(this.userRepository.findByUsername(username)), HttpStatus.OK);
    }

    @ApiOperation(value="Creates a new User")
    @RequestMapping(method={RequestMethod.POST}, value={"/users"}, consumes={"application/json"})
    public ResponseEntity<Boolean> registerUserAccount(@ApiParam(value="User Data Transfer Object", required=true) @RequestBody @Valid UserAccount account) {
        if (this.userRepository.findByEmail(account.getEmail()) != null && this.userRepository.findByUsername(account.getUsername()) != null) {
            return new ResponseEntity((Object)false, HttpStatus.CREATED);
        }
        this.LOGGER.debug("Register new user account with information: {}", (Object)account);
        account.setPassword(this.passwordEncoder.encode((CharSequence)account.getPassword()));
        this.accountService.create(account);
        return new ResponseEntity((Object)true, HttpStatus.CREATED);
    }

    @ApiOperation(value="Update an existing User")
    @RequestMapping(method={RequestMethod.PUT}, value={"/users/{username}"})
    public ResponseEntity<UserDto> updateUser(Principal currentlyLoggedInUser, @ApiParam(value=" Username", required=true) @PathVariable String username, @ApiParam(value="User Data Transfer Object", required=true) @RequestBody UserDto userDto) {
        if (!this.isUpdateAllowed(currentlyLoggedInUser, username, userDto)) {
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        User user = this.userRepository.findByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("User does not exists");
        }
        user.setUsername(userDto.getUsername());
        user.setEmail(userDto.getEmail());
        user.setLastUpdated(new Timestamp(System.currentTimeMillis()));
        if (UserUtils.isAdmin(currentlyLoggedInUser)) {
            user.setHasWatchOnRepository(userDto.isHasWatchOnRepository());
        }
        this.userRepository.save(user);
        User updatedUser = this.userRepository.findByUsername(userDto.getUsername());
        return new ResponseEntity((Object)UserDto.fromUser(updatedUser), HttpStatus.OK);
    }

    private boolean isUpdateAllowed(Principal currentlyLoggedInUser, String username, UserDto userDto) {
        if (username == null || currentlyLoggedInUser == null || userDto == null) {
            return false;
        }
        if (UserUtils.isAdmin(currentlyLoggedInUser)) {
            if ("admin".equals(username)) {
                return "admin".equals(userDto.getUsername());
            }
            return !"admin".equals(userDto.getUsername());
        }
        return UserUtils.sameUser(currentlyLoggedInUser, username) && username.equals(userDto.getUsername()) && !"admin".equals(userDto.getUsername());
    }

    @ApiOperation(value="Compares an Email-Address with all already existing Email-Addresses")
    @RequestMapping(method={RequestMethod.POST}, value={"/users/unique/email"})
    public ResponseEntity<Boolean> checkEmailAdressAlreadyExists(@ApiParam(value="Email-Address", required=true) @RequestBody String email) {
        boolean emailExists = false;
        emailExists = this.userRepository.findByEmail(email) != null;
        return new ResponseEntity((Object)emailExists, HttpStatus.OK);
    }

    @ApiOperation(value="Compares a username with all already existing usernames")
    @RequestMapping(method={RequestMethod.POST}, value={"/users/unique/username"}, consumes={"application/json"})
    public ResponseEntity<Boolean> checkUsernameAlreadyExists(@ApiParam(value="Username", required=true) @RequestBody String username) {
        boolean userExists = false;
        userExists = this.userRepository.findByUsername(username) != null;
        this.LOGGER.debug("username exists: " + userExists);
        return new ResponseEntity((Object)userExists, HttpStatus.OK);
    }

    @ApiOperation(value="Deletes the user's user account")
    @RequestMapping(value={"/users/{username}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#username,'user:delete')")
    public ResponseEntity<Void> deleteAccount(@PathVariable(value="username") String username) {
        this.accountService.delete(username);
        return new ResponseEntity(HttpStatus.OK);
    }
}

