/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.validation;

import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.InvocationContext;
import org.eclipse.vorto.repository.core.impl.validation.IModelValidator;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;

public class DuplicateModelValidation
implements IModelValidator {
    private IModelRepository modelRepository;

    public DuplicateModelValidation(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    @Override
    public void validate(ModelInfo modelResource, InvocationContext context) throws ValidationException {
        ModelInfo existingModel = this.modelRepository.getById(modelResource.getId());
        if (existingModel != null && !this.isAdmin(context) && !this.isAuthor(existingModel, context)) {
            throw new ValidationException("Model already exists", modelResource);
        }
    }

    private boolean isAdmin(InvocationContext context) {
        return context.getUsername().equalsIgnoreCase("admin");
    }

    private boolean isAuthor(ModelInfo model, InvocationContext context) {
        return model.getAuthor().equalsIgnoreCase(context.getUsername());
    }
}

