/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.validation;

import java.util.List;
import java.util.Objects;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;

public class CouldNotResolveReferenceException
extends ValidationException {
    private static final long serialVersionUID = -6078848052990402848L;
    private List<ModelId> missingReferences;

    public CouldNotResolveReferenceException(ModelInfo resource, List<ModelId> missingReferences) {
        super(CouldNotResolveReferenceException.createErrorMessage(missingReferences), resource);
        this.missingReferences = Objects.requireNonNull(missingReferences);
        if (missingReferences.size() <= 0) {
            throw new IllegalArgumentException("Trying to create a CouldNotResolveReferenceException with empty missingReferences.");
        }
    }

    public List<ModelId> getMissingReferences() {
        return this.missingReferences;
    }

    private static String createErrorMessage(List<ModelId> missingReferences) {
        if (missingReferences.size() > 1) {
            return "Cannot resolve multiple references.";
        }
        return String.format("Cannot resolve reference %s", missingReferences.get(0).getPrettyFormat());
    }
}

