/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.utils;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.vorto.repository.api.ModelId;

public class ModelIdHelper {
    private ModelId modelId;
    private static final String PATH_DELIMITER = "/";

    public ModelIdHelper(ModelId modelId) {
        this.modelId = modelId;
    }

    public String getFullPath() {
        StringBuilder path = new StringBuilder(this.getNamespacePath());
        path.append(PATH_DELIMITER);
        path.append(this.modelId.getName());
        path.append(PATH_DELIMITER);
        path.append(this.modelId.getVersion());
        return path.toString();
    }

    public String getNamespacePath() {
        StringBuilder path = new StringBuilder(PATH_DELIMITER);
        StringTokenizer tokenizer = new StringTokenizer(this.modelId.getNamespace(), ".");
        while (tokenizer.hasMoreTokens()) {
            path.append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            path.append(PATH_DELIMITER);
        }
        return path.toString();
    }

    public static ModelId fromPath(String path) {
        String[] pathFragments = path.substring(1).split(PATH_DELIMITER);
        return new ModelId(pathFragments[pathFragments.length - 2], ModelIdHelper.convertToNamespace(pathFragments), pathFragments[pathFragments.length - 1]);
    }

    private static String convertToNamespace(String[] fragments) {
        StringBuilder namespaceBuilder = new StringBuilder();
        for (int i = 0; i < fragments.length - 2; ++i) {
            namespaceBuilder.append(fragments[i]);
            if (i >= fragments.length - 3) continue;
            namespaceBuilder.append(".");
        }
        return namespaceBuilder.toString();
    }

    public Iterator<String> iterator() {
        return new StringTokenizerIterator(this.getFullPath());
    }

    private static class StringTokenizerIterator
    implements Iterator<String> {
        private StringTokenizer enumeration;

        public StringTokenizerIterator(String fullPath) {
            this.enumeration = new StringTokenizer(fullPath.substring(1), ModelIdHelper.PATH_DELIMITER);
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public String next() {
            return this.enumeration.nextToken();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

