/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.upload.UploadModelResult;
import org.eclipse.vorto.repository.core.FatalModelRepositoryException;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.ITemporaryStorage;
import org.eclipse.vorto.repository.core.impl.InvocationContext;
import org.eclipse.vorto.repository.core.impl.ModelEMFResource;
import org.eclipse.vorto.repository.core.impl.UploadModelResultFactory;
import org.eclipse.vorto.repository.core.impl.parser.ModelParserFactory;
import org.eclipse.vorto.repository.core.impl.utils.DependencyManager;
import org.eclipse.vorto.repository.core.impl.validation.BulkModelDuplicateIdValidation;
import org.eclipse.vorto.repository.core.impl.validation.BulkModelReferencesValidation;
import org.eclipse.vorto.repository.core.impl.validation.DuplicateModelValidation;
import org.eclipse.vorto.repository.core.impl.validation.IModelValidator;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;
import org.springframework.util.StringUtils;

public class BulkUploadHelper {
    public static final long TTL_TEMP_STORAGE_INSECONDS = 300L;
    private IModelRepository repositoryService;
    private ITemporaryStorage uploadStorage;

    public BulkUploadHelper(IModelRepository modelRepository, ITemporaryStorage storage) {
        this.repositoryService = modelRepository;
        this.uploadStorage = storage;
    }

    public List<UploadModelResult> uploadMultiple(byte[] content, String zipFileName, String callerId) {
        if (!this.isValid(zipFileName)) {
            throw new FatalModelRepositoryException("Filename/type is invalid", null);
        }
        ArrayList<UploadModelResult> invalidResult = new ArrayList<UploadModelResult>();
        ArrayList<UploadModelResult> validResult = new ArrayList<UploadModelResult>();
        HashSet<ModelInfo> parsedModels = new HashSet<ModelInfo>();
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(content));
        ZipEntry entry = null;
        block8: while (true) {
            try {
                while ((entry = zis.getNextEntry()) != null) {
                    String fileName;
                    if (entry.isDirectory() || !ModelParserFactory.hasParserFor(fileName = entry.getName())) continue;
                    try {
                        parsedModels.add(ModelParserFactory.getParser(fileName).parse(new ByteArrayInputStream(BulkUploadHelper.copyStream(zis, entry))));
                        continue block8;
                    }
                    catch (ValidationException grammarProblem) {
                        invalidResult.add(UploadModelResultFactory.create(grammarProblem));
                    }
                }
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break;
            }
        }
        try {
            List<IModelValidator> bulkUploadValidators = this.constructBulkUploadValidators(parsedModels);
            for (ModelInfo modelResource : parsedModels) {
                try {
                    for (IModelValidator validator : bulkUploadValidators) {
                        validator.validate(modelResource, InvocationContext.create(callerId));
                    }
                    UploadModelResult result = UploadModelResult.valid((ModelInfo)modelResource);
                    if (invalidResult.contains(result)) continue;
                    validResult.add(result);
                }
                catch (ValidationException validationException) {
                    invalidResult.add(UploadModelResultFactory.create(validationException));
                }
            }
            if (invalidResult.isEmpty()) {
                DependencyManager dm = new DependencyManager(parsedModels);
                return this.safelyUpload(dm.getSorted());
            }
            ArrayList<UploadModelResult> completeResult = new ArrayList<UploadModelResult>();
            completeResult.addAll(invalidResult);
            completeResult.addAll(validResult);
            return completeResult;
        }
        catch (Exception e) {
            throw new FatalModelRepositoryException("Invalid zip file", e);
        }
    }

    private List<UploadModelResult> safelyUpload(Collection<ModelInfo> resources) throws Exception {
        ArrayList<UploadModelResult> result = new ArrayList<UploadModelResult>();
        for (ModelInfo resource : resources) {
            result.add(UploadModelResult.valid((String)this.createUploadHandle(((ModelEMFResource)resource).toDSL(), resource.getType()), (ModelInfo)resource));
        }
        return result;
    }

    private String createUploadHandle(byte[] content, ModelType type) {
        String handleId = UUID.randomUUID().toString() + type.getExtension();
        return this.uploadStorage.store(handleId, content, 300L).getKey();
    }

    private boolean isValid(String file) {
        return !StringUtils.isEmpty((Object)file) && StringUtils.endsWithIgnoreCase((String)file, (String)".zip");
    }

    private List<IModelValidator> constructBulkUploadValidators(Set<ModelInfo> modelResources) {
        LinkedList<IModelValidator> bulkUploadValidators = new LinkedList<IModelValidator>();
        bulkUploadValidators.add(new DuplicateModelValidation(this.repositoryService));
        bulkUploadValidators.add(new BulkModelDuplicateIdValidation(this.repositoryService, modelResources));
        bulkUploadValidators.add(new BulkModelReferencesValidation(this.repositoryService, modelResources));
        return bulkUploadValidators;
    }

    protected static byte[] copyStream(ZipInputStream in, ZipEntry entry) throws Exception {
        int size;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        BufferedOutputStream bos = new BufferedOutputStream(out);
        while ((size = in.read(buffer, 0, buffer.length)) != -1) {
            bos.write(buffer, 0, size);
        }
        bos.flush();
        bos.close();
        return out.toByteArray();
    }
}

