/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.vorto.repository.core.impl.ITemporaryStorage;
import org.eclipse.vorto.repository.core.impl.StorageItem;

public class InMemoryTemporaryStorage
implements ITemporaryStorage {
    private Map<String, StorageItem> storage = new HashMap<String, StorageItem>();
    private static Logger logger = Logger.getLogger(InMemoryTemporaryStorage.class);

    @Override
    public StorageItem store(String key, Object value, long timeToLiveSeconds) {
        StorageItem newItem = new StorageItem(key, value, new Date(), timeToLiveSeconds);
        this.storage.put(key, newItem);
        logger.info((Object)("Added " + newItem + " in temporary storage"));
        return newItem;
    }

    @Override
    public StorageItem get(String key) {
        StorageItem item = this.storage.get(key);
        if (item != null && item.isExpired()) {
            this.remove(key);
            item = null;
        }
        return item;
    }

    @Override
    public StorageItem remove(String key) {
        logger.info((Object)("Removing " + key + " from temporary storage"));
        return this.storage.remove(key);
    }

    @Override
    public void clearExpired() {
        logger.info((Object)"Clearing expired storage items from temporary storage");
        Iterator<String> iter = this.storage.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            StorageItem item = this.storage.get(key);
            if (!item.isExpired()) continue;
            logger.info((Object)("Removing " + key + " from temporary storage"));
            iter.remove();
        }
    }
}

