/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.comment.impl;

import java.util.Date;
import java.util.List;
import javax.jcr.PathNotFoundException;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.comment.Comment;
import org.eclipse.vorto.repository.comment.ICommentService;
import org.eclipse.vorto.repository.comment.impl.CommentRepository;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultCommentService
implements ICommentService {
    @Autowired
    private IModelRepository modelRepository;
    @Autowired
    private CommentRepository commentRepository;

    @Override
    public void createComment(Comment comment) {
        ModelId id = ModelId.fromPrettyFormat((String)comment.getModelId());
        if (this.modelRepository.getById(id) == null) {
            throw new ModelNotFoundException("Model not found", (Throwable)new PathNotFoundException());
        }
        comment.setModelId(id.getPrettyFormat());
        comment.setDate(new Date());
        this.commentRepository.save(comment);
    }

    @Override
    public List<Comment> getCommentsforModelId(ModelId modelId) {
        return this.commentRepository.findByModelId(modelId.getPrettyFormat());
    }
}

