/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.account.impl;

import java.sql.Timestamp;
import java.util.List;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.account.Role;
import org.eclipse.vorto.repository.account.UserAccount;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.notification.INotificationService;
import org.eclipse.vorto.repository.notification.message.DeleteAccountMessage;
import org.eclipse.vorto.repository.notification.message.RegistrationMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultUserAccountService
implements IUserAccountService {
    private static final String USER_ANONYMOUS = "anonymous";
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private INotificationService notificationService;
    @Autowired
    private IModelRepository modelRepository;

    @Override
    public void create(UserAccount account) {
        User user = new User();
        user.setUsername(account.getUsername());
        user.setPassword(account.getPassword());
        user.setHasWatchOnRepository(false);
        user.setEmail(account.getEmail());
        user.setDateCreated(new Timestamp(System.currentTimeMillis()));
        user.setLastUpdated(new Timestamp(System.currentTimeMillis()));
        user.setRoles(Role.USER);
        User registered = (User)this.userRepository.save(user);
        this.notificationService.sendNotification(new RegistrationMessage(registered));
    }

    @Override
    public void delete(String userId) {
        User userToDelete = this.userRepository.findByUsername(userId);
        if (userToDelete != null) {
            this.makeModelsAnonymous(userToDelete.getUsername());
            this.userRepository.delete(userToDelete);
            this.notificationService.sendNotification(new DeleteAccountMessage(userToDelete));
        }
    }

    private void makeModelsAnonymous(String username) {
        List<ModelInfo> userModels = this.modelRepository.search("author:" + username);
        for (ModelInfo model : userModels) {
            model.setAuthor(USER_ANONYMOUS);
            this.modelRepository.updateMeta(model);
        }
    }

    public INotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(INotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public IUserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(IUserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public void setModelRepository(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    @Override
    public boolean exists(String userId) {
        return this.userRepository.findByUsername(userId) != null;
    }
}

