/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.identity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import org.eclipse.vorto.repository.model.User;
import org.eclipse.vorto.repository.model.UserDto;
import org.eclipse.vorto.repository.service.IRegistrationService;
import org.eclipse.vorto.repository.service.IUserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="User Controller", description="REST API to manage User")
@RestController
@RequestMapping(value={"/rest"})
public class UserController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private IRegistrationService registrationService;
    @Autowired(required=false)
    private PasswordEncoder passwordEncoder;

    @ApiOperation(value="Returns a specified User")
    @ApiResponses(value={@ApiResponse(code=404, message="Not found"), @ApiResponse(code=200, message="OK")})
    @RequestMapping(method={RequestMethod.GET}, value={"/users/{username:.+}"})
    public ResponseEntity<User> getUser(@ApiParam(value="Username", required=true) @PathVariable String username) {
        this.LOGGER.debug("User {} - {} ", (Object)username, (Object)this.userRepository.findByUsername(username));
        return new ResponseEntity((Object)this.userRepository.findByUsername(username), HttpStatus.OK);
    }

    @ApiOperation(value="Creates a new User")
    @RequestMapping(method={RequestMethod.POST}, value={"/users"}, consumes={"application/json"})
    public ResponseEntity<Boolean> registerUserAccount(@ApiParam(value="User Data Transfer Object", required=true) @RequestBody @Valid UserDto userDto) {
        if (this.userRepository.findByEmail(userDto.getEmail()) != null && this.userRepository.findByUsername(userDto.getUsername()) != null) {
            return new ResponseEntity((Object)false, HttpStatus.CREATED);
        }
        this.LOGGER.debug("Register new user account with information: {}", (Object)userDto);
        userDto.setPassword(this.passwordEncoder.encode((CharSequence)userDto.getPassword()));
        this.registrationService.registerUser(userDto);
        return new ResponseEntity((Object)true, HttpStatus.CREATED);
    }

    @ApiOperation(value="Update an existing User")
    @RequestMapping(method={RequestMethod.PUT}, value={"/users/{username}"})
    public ResponseEntity<User> updateUser(@ApiParam(value="Username", required=true) @PathVariable String username, @ApiParam(value="User Data Transfer Object", required=true) @RequestBody UserDto userDto) {
        User user = this.userRepository.findByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("User does not exists");
        }
        user.setFirstName(userDto.getFirstName());
        user.setLastName(userDto.getLastName());
        user.setUsername(userDto.getUsername());
        user.setEmail(userDto.getEmail());
        user.setHasWatchOnRepository(userDto.getHasWatchOnRepository());
        this.userRepository.save((Object)user);
        return new ResponseEntity((Object)this.userRepository.findByUsername(username), HttpStatus.OK);
    }

    @ApiOperation(value="Compares an Email-Address with all already existing Email-Addresses")
    @RequestMapping(method={RequestMethod.POST}, value={"/users/unique/email"})
    public ResponseEntity<Boolean> checkEmailAdressAlreadyExists(@ApiParam(value="Email-Address", required=true) @RequestBody String email) {
        boolean emailExists = false;
        emailExists = this.userRepository.findByEmail(email) != null;
        return new ResponseEntity((Object)emailExists, HttpStatus.OK);
    }

    @ApiOperation(value="Compares a username with all already existing usernames")
    @RequestMapping(method={RequestMethod.POST}, value={"/users/unique/username"}, consumes={"application/json"})
    public ResponseEntity<Boolean> checkUsernameAlreadyExists(@ApiParam(value="Username", required=true) @RequestBody String username) {
        boolean userExists = false;
        userExists = this.userRepository.findByUsername(username) != null;
        this.LOGGER.debug("username exists: " + userExists);
        return new ResponseEntity((Object)userExists, HttpStatus.OK);
    }
}

