/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web;

import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vorto.repository.api.upload.ModelHandle;
import org.eclipse.vorto.repository.api.upload.ServerResponse;
import org.eclipse.vorto.repository.api.upload.UploadModelResult;
import org.eclipse.vorto.repository.internal.service.ITemporaryStorage;
import org.eclipse.vorto.repository.internal.service.utils.BulkUploadHelper;
import org.eclipse.vorto.repository.service.IModelRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="/share", description="Upload information models")
@RestController
@RequestMapping(value={"/rest/secure"})
public class ShareModelController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final String ERROR_MSG_FORMAT = "Models cannot be checked in because there {0,choice,1#is|1<are} {0} {0,choice,1#model|1<models} with {0,choice,1#error|1<errors}.";
    private final String SUCCESS_MSG_FORMAT = "{0,choice,1#The uploaded model is|1<All uploaded models are} valid and ready to check in.";
    @Autowired
    private IModelRepository modelRepository;
    @Autowired
    private ITemporaryStorage uploadStorage;
    private UploadModelResult uploadModelResult;

    @ApiOperation(value="Upload and validate a single vorto model")
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<ServerResponse> uploadModel(@ApiParam(value="The vorto model file to upload", required=true) @RequestParam(value="file") MultipartFile file) {
        this.LOGGER.info("uploadModel: [" + file.getOriginalFilename() + "]");
        try {
            this.uploadModelResult = this.modelRepository.upload(file.getBytes(), file.getOriginalFilename());
            ArrayList uploadModelResults = Lists.newArrayList();
            uploadModelResults.add(this.uploadModelResult);
            String message = "Uploaded model " + file.getOriginalFilename() + (this.uploadModelResult.isValid() ? " is valid to check in." : " has errors. Cannot check in.");
            return this.validResponse(new ServerResponse(message, Boolean.valueOf(true), (Object)uploadModelResults));
        }
        catch (IOException e) {
            this.LOGGER.error("Error upload model." + e.getStackTrace());
            ServerResponse errorResponse = new ServerResponse("Error during upload. Try again. " + e.getMessage(), Boolean.valueOf(false), null);
            return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Upload and validate multiple vorto models")
    @RequestMapping(value={"multiple"}, method={RequestMethod.POST})
    public ResponseEntity<ServerResponse> uploadMultipleModels(@ApiParam(value="The vorto model files to upload", required=true) @RequestParam(value="file") MultipartFile file) {
        this.LOGGER.info("Bulk upload Models: [" + file.getOriginalFilename() + "]");
        try {
            BulkUploadHelper bulkUploadService = new BulkUploadHelper(this.modelRepository, this.uploadStorage);
            List uploadModelResults = bulkUploadService.uploadMultiple(file.getBytes(), file.getOriginalFilename());
            this.LOGGER.info("Models Uploaded: [" + uploadModelResults.size() + "]");
            ServerResponse serverResponse = uploadModelResults.size() == 0 ? new ServerResponse("Uploaded file doesn't have any valid models.", Boolean.valueOf(false), (Object)uploadModelResults) : new ServerResponse(this.constructUserResponseMessage(uploadModelResults), Boolean.valueOf(true), (Object)uploadModelResults);
            return this.validResponse(serverResponse);
        }
        catch (Exception e) {
            this.LOGGER.error("Error bulk upload models.", (Throwable)e);
            return this.erroredResponse("Error during upload. Try again. " + e.getMessage());
        }
    }

    @ApiOperation(value="Checkin an uploaded vorto model into the repository")
    @RequestMapping(value={"/{handleId:.+}"}, method={RequestMethod.PUT})
    public ResponseEntity<ServerResponse> checkin(@ApiParam(value="The file name of uploaded vorto model", required=true) @PathVariable String handleId) {
        this.LOGGER.info("Check in Model " + handleId);
        try {
            this.modelRepository.checkin(handleId, SecurityContextHolder.getContext().getAuthentication().getName());
            ServerResponse successModelResponse = new ServerResponse("Model has been checkin successfully.", Boolean.valueOf(true), null);
            return this.validResponse(successModelResponse);
        }
        catch (Exception e) {
            this.LOGGER.error("Error checkin model. " + handleId, (Throwable)e);
            return this.erroredResponse("Error during checkin. Try again. " + e.getMessage());
        }
    }

    @ApiOperation(value="Checkin multiple uploaded vorto models into the  repository")
    @RequestMapping(value={"/checkInMultiple"}, method={RequestMethod.PUT})
    public ResponseEntity<ServerResponse> checkInMultiple(@ApiParam(value="The file name of uploaded vorto model", required=true) @RequestBody ModelHandle[] modelHandles) {
        this.LOGGER.info("Bulk check in models.");
        try {
            for (ModelHandle handle : modelHandles) {
                this.modelRepository.checkin(handle.getHandleId(), SecurityContextHolder.getContext().getAuthentication().getName());
            }
            ServerResponse successModelResponse = new ServerResponse("All the models has been checked in Successfully.", Boolean.valueOf(true), null);
            return this.validResponse(successModelResponse);
        }
        catch (Exception e) {
            this.LOGGER.error("Error bulk checkin models.", (Throwable)e);
            return this.erroredResponse("Error during checkin. Try again. " + e.getMessage());
        }
    }

    private ResponseEntity<ServerResponse> validResponse(ServerResponse successModelResponse) {
        return new ResponseEntity((Object)successModelResponse, HttpStatus.OK);
    }

    private ResponseEntity<ServerResponse> erroredResponse(String errorMessage) {
        ServerResponse errorResponse = new ServerResponse("Error during checkin. Try again. " + errorMessage, Boolean.valueOf(false), null);
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private String constructUserResponseMessage(List<UploadModelResult> uploadModelResults) {
        if (uploadModelResults.size() == 0) {
            return "No valid models found. Nothing to checkin";
        }
        long noOfInvalidModels = uploadModelResults.stream().filter(result -> !result.isValid()).count();
        return noOfInvalidModels > 0L ? this.resolveMessage("Models cannot be checked in because there {0,choice,1#is|1<are} {0} {0,choice,1#model|1<models} with {0,choice,1#error|1<errors}.", noOfInvalidModels) : this.resolveMessage("{0,choice,1#The uploaded model is|1<All uploaded models are} valid and ready to check in.", (long)uploadModelResults.size());
    }

    private String resolveMessage(String messageFormat, long occurences) {
        return MessageFormat.format(messageFormat, occurences);
    }
}

