/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.validation.constraints.NotNull;

@Entity
public class Generator {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    private String generatorKey;
    @NotNull
    private String baseUrl;
    @NotNull
    private String classifier;
    @NotNull
    private Integer invocationCount;

    public Generator() {
    }

    public Generator(String generatorKey, String baseUrl, String classifier) {
        this.generatorKey = generatorKey;
        this.baseUrl = baseUrl;
        this.classifier = classifier;
        this.invocationCount = 0;
    }

    public Integer increaseInvocationCount() {
        this.invocationCount = this.invocationCount + 1;
        return this.invocationCount;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getKey() {
        return this.generatorKey;
    }

    public void setKey(String generatorKey) {
        this.generatorKey = generatorKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public void setInvocationCount(Integer invocationCount) {
        this.invocationCount = invocationCount;
    }

    public String getGenerationEndpointUrl() {
        return this.baseUrl + "/{namespace}/{name}/{version}";
    }

    public String getGenerationInfoUrl() {
        return this.baseUrl + "/info";
    }
}

