/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.notification;

import com.sun.mail.smtp.SMTPMessage;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;
import org.eclipse.vorto.repository.internal.service.notification.IMessage;
import org.eclipse.vorto.repository.internal.service.notification.INotificationService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EmailNotificationService
implements INotificationService {
    private static Logger logger = Logger.getLogger(EmailNotificationService.class);
    @Value(value="${mail.from}")
    private String mailFrom;
    @Value(value="${mail.smtp.host}")
    private String smtpHost;
    @Value(value="${mail.smtp.port}")
    private String smtpPort;
    @Value(value="${mail.smtp.auth}")
    private String needsAuth = "false";
    @Value(value="${mail.login.username}")
    private String mailUser;
    @Value(value="${mail.login.password}")
    private String mailPassword;

    public void sendNotification(IMessage message) {
        this.doSendEmail(message);
    }

    private void doSendEmail(IMessage message) {
        try {
            Session emailSession = this.newSession();
            Transport transport = emailSession.getTransport("smtp");
            transport.connect();
            SMTPMessage smtpMessage = new SMTPMessage(emailSession);
            smtpMessage.setFrom((Address)new InternetAddress(this.mailFrom));
            smtpMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)message.getRecipient().getEmail()));
            smtpMessage.setHeader("Content-Type", "text/html");
            smtpMessage.setSubject(message.getSubject());
            smtpMessage.setContent((Object)message.getContent(), "text/html");
            smtpMessage.setNotifyOptions(1);
            smtpMessage.setReturnOption(1);
            transport.sendMessage((Message)smtpMessage, (Address[])InternetAddress.parse((String)message.getRecipient().getEmail()));
            transport.close();
        }
        catch (MessagingException me) {
            logger.error((Object)"Problem sending email", (Throwable)me);
        }
    }

    private Session newSession() {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", this.smtpHost);
        props.setProperty("mail.smtp.port", this.smtpPort);
        String mailUser = this.mailUser;
        String mailPassword = this.mailPassword;
        return Session.getDefaultInstance((Properties)props, (Authenticator)(Boolean.valueOf(this.needsAuth) == false ? null : new /* Unavailable Anonymous Inner Class!! */));
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getNeedsAuth() {
        return this.needsAuth;
    }

    public void setNeedsAuth(String needsAuth) {
        this.needsAuth = needsAuth;
    }
}

