/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.server.config.config.plugins;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Base64;
import javax.annotation.PostConstruct;
import org.eclipse.vorto.plugin.importer.ImporterPluginInfo;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.core.IModelRepositoryFactory;
import org.eclipse.vorto.repository.core.impl.ITemporaryStorage;
import org.eclipse.vorto.repository.core.impl.parser.ModelParserFactory;
import org.eclipse.vorto.repository.importer.IModelImporter;
import org.eclipse.vorto.repository.importer.impl.DefaultModelImportService;
import org.eclipse.vorto.repository.plugin.generator.GeneratorPluginConfiguration;
import org.eclipse.vorto.repository.plugin.generator.impl.DefaultGeneratorPluginService;
import org.eclipse.vorto.repository.plugin.importer.RemoteImporter;
import org.eclipse.vorto.repository.server.config.config.plugins.Plugin;
import org.eclipse.vorto.repository.tenant.ITenantService;
import org.eclipse.vorto.repository.tenant.ITenantUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
public class PluginConfiguration {
    @Autowired
    private IModelRepositoryFactory modelRepositoryFactory;
    @Autowired
    private ModelParserFactory modelParserFactory;
    @Autowired
    private IUserAccountService userAccountService;
    @Autowired
    private ITenantService tenantService;
    @Autowired
    private ITenantUserService tenantUserService;
    @Value(value="${plugins:#{null}}")
    private String pluginsJson;
    @Autowired
    private ITemporaryStorage fileStorage;
    @Autowired
    private DefaultGeneratorPluginService generatorPluginService;
    @Autowired
    private DefaultModelImportService importerPluginService;
    @Autowired
    private RestTemplate restTemplate;

    @PostConstruct
    public void registerPlugins() throws Exception {
        if (this.pluginsJson == null) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        Plugin[] plugins = (Plugin[])mapper.readValue(Base64.getDecoder().decode(this.pluginsJson.getBytes()), Plugin[].class);
        if (plugins != null && plugins.length > 0) {
            Arrays.asList(plugins).stream().forEach(plugin -> {
                if (plugin.getPluginType().equals((Object)Plugin.PluginType.generator)) {
                    GeneratorPluginConfiguration config = GeneratorPluginConfiguration.of((String)plugin.getKey(), (String)plugin.getApiVersion(), (String)plugin.getEndpoint(), (String[])new String[0]);
                    if (plugin.getTag() != null) {
                        config.setTags(new String[]{plugin.getTag()});
                    }
                    this.generatorPluginService.registerPlugin(config);
                } else {
                    ImporterPluginInfo info = new ImporterPluginInfo(plugin.getKey(), plugin.getName(), plugin.getDescription(), plugin.getVendor(), plugin.getFileType());
                    this.importerPluginService.registerImporter((IModelImporter)this.createImporter(info, plugin.getEndpoint()));
                }
            });
        }
    }

    private RemoteImporter createImporter(ImporterPluginInfo info, String endpointUrl) {
        RemoteImporter importer = new RemoteImporter(info, endpointUrl);
        importer.setModelParserFactory(this.modelParserFactory);
        importer.setModelRepoFactory(this.modelRepositoryFactory);
        importer.setTenantUserService(this.tenantUserService);
        importer.setTenantService(this.tenantService);
        importer.setUploadStorage(this.fileStorage);
        importer.setUserRepository(this.userAccountService);
        importer.setRestTemplate(this.restTemplate);
        return importer;
    }
}

