/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.server.config.config;

import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.Signer;
import com.amazonaws.http.AWSRequestSigningApacheInterceptor;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.log4j.Logger;
import org.eclipse.vorto.repository.core.IModelRepositoryFactory;
import org.eclipse.vorto.repository.search.ElasticSearchService;
import org.eclipse.vorto.repository.tenant.ITenantService;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"prod", "int", "local-docker"})
public class ElasticSearchConfiguration {
    @Value(value="${server.config.skipSslVerification:false}")
    private boolean skipSslVerification;
    @Value(value="${http.proxyHost:#{null}}")
    private String proxyHost;
    @Value(value="${http.proxyPort:8080}")
    protected int proxyPort;
    @Value(value="${http.proxyUser:#{null}}")
    private String proxyUsername;
    @Value(value="${http.proxyPassword:#{null}}")
    private String proxyPassword;
    private String serviceName = "es";
    @Value(value="${aws.region:eu-central-1}")
    private String region;
    @Value(value="${aws.aesEndpoint:https://search-vorto-test-i566tsfta74oi6s6hbzfwproui.eu-central-1.es.amazonaws.com}")
    private String aesEndpoint;
    private AWSCredentialsProvider credentialsProvider = new DefaultAWSCredentialsProviderChain();
    private static Logger logger = Logger.getLogger(ElasticSearchConfiguration.class);
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private IModelRepositoryFactory repositoryFactory;
    @Autowired
    private ITenantService tenantService;

    @Bean
    @Profile(value={"prod", "int", "local-docker"})
    public ElasticSearchService elasticSearch() {
        return new ElasticSearchService(this.client, this.repositoryFactory, this.tenantService);
    }

    @Bean
    @Profile(value={"local-docker"})
    public RestHighLevelClient indexingClient() {
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost("localhost", 9200, "http"), new HttpHost("localhost", 9201, "http")});
        return new RestHighLevelClient(clientBuilder);
    }

    @Bean
    @Profile(value={"prod", "int"})
    public RestHighLevelClient awsIndexingClient() {
        logger.info((Object)("Creating an elastic server client with config(serviceName=" + this.serviceName + " region=" + this.region + " aesEndpoint=" + this.aesEndpoint));
        AWS4Signer signer = new AWS4Signer();
        signer.setServiceName(this.serviceName);
        signer.setRegionName(this.region);
        AWSRequestSigningApacheInterceptor interceptor = new AWSRequestSigningApacheInterceptor(this.serviceName, (Signer)signer, this.credentialsProvider);
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)this.aesEndpoint)}).setHttpClientConfigCallback(this.httpClientConfig(this.getProxy(), (HttpRequestInterceptor)interceptor));
        return new RestHighLevelClient(builder);
    }

    private RestClientBuilder.HttpClientConfigCallback httpClientConfig(Optional<HttpHost> proxy, HttpRequestInterceptor interceptor) {
        return httpClientBuilder -> {
            httpClientBuilder.addInterceptorLast(interceptor);
            if (proxy.isPresent()) {
                httpClientBuilder.setProxy((HttpHost)proxy.get());
                Optional<CredentialsProvider> credentialProvider = this.getCredentialsProvider((HttpHost)proxy.get());
                if (credentialProvider.isPresent()) {
                    httpClientBuilder.setDefaultCredentialsProvider(credentialProvider.get());
                }
            }
            if (this.skipSslVerification) {
                try {
                    SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509Certificates, s) -> true).build();
                    httpClientBuilder.setSSLContext(sslContext);
                    httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                }
                catch (Exception e) {
                    logger.error((Object)"Error while trying to skip SSL verification", (Throwable)e);
                }
            }
            return httpClientBuilder;
        };
    }

    private Optional<HttpHost> getProxy() {
        if (!Strings.isNullOrEmpty((String)this.proxyHost)) {
            return Optional.of(new HttpHost(this.proxyHost, this.proxyPort, "http"));
        }
        return Optional.empty();
    }

    private Optional<CredentialsProvider> getCredentialsProvider(HttpHost host) {
        if (!Strings.isNullOrEmpty((String)this.proxyUsername)) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(host.getHostName(), host.getPort()), (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
            return Optional.of(credsProvider);
        }
        return Optional.empty();
    }

    @PreDestroy
    public void deinit() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            logger.error((Object)"Not able to close indexing client", (Throwable)e);
        }
    }
}

