/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.server.config.config;

import java.net.URL;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.actuator.GeneratorsHealthCheck;
import org.eclipse.vorto.repository.generation.impl.IGeneratorLookupRepository;
import org.eclipse.vorto.repository.server.config.config.BaseConfiguration;
import org.eclipse.vorto.repository.sso.TokenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RepositoryConfiguration
extends BaseConfiguration {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Value(value="${http.proxyHost:#{null}}")
    private String proxyHost;
    @Value(value="${http.proxyPort:8080}")
    protected int proxyPort;
    @Value(value="${http.proxyUser:#{null}}")
    private String proxyUsername;
    @Value(value="${http.proxyPassword:#{null}}")
    private String proxyPassword;
    @Value(value="${repo.configFile}")
    private String repositoryConfigFile = null;
    @Autowired
    private IUserAccountService userAccountService;
    @Value(value="${oauth2.verification.eidp.technicalUsers:}")
    private String[] ciamTechnicalUsers;
    @Value(value="${oauth2.verification.keycloak.technicalUsers:}")
    private String[] keycloakTechnicalUsers;

    @Bean
    public org.modeshape.jcr.RepositoryConfiguration repoConfiguration() throws Exception {
        return org.modeshape.jcr.RepositoryConfiguration.read((URL)new ClassPathResource(this.repositoryConfigFile).getURL());
    }

    @Bean
    public AccessTokenProvider accessTokenProvider() {
        if (this.proxyHost != null && this.proxyUsername != null) {
            return TokenUtils.proxiedAccessTokenProvider((String)this.proxyHost, (int)this.proxyPort, (String)this.proxyUsername, (String)this.proxyPassword);
        }
        if (this.proxyHost != null && this.proxyUsername == null) {
            return TokenUtils.proxiedAccessTokenProvider((String)this.proxyHost, (int)this.proxyPort);
        }
        return TokenUtils.accessTokenProvider();
    }

    @Bean
    public GeneratorsHealthCheck generatorsHealthCheck(IGeneratorLookupRepository registeredGeneratorsRepository) {
        return new GeneratorsHealthCheck(registeredGeneratorsRepository, new RestTemplate());
    }

    @PostConstruct
    public void setupTechnicalUsers() {
        Stream.concat(Stream.of(this.ciamTechnicalUsers), Stream.of(this.keycloakTechnicalUsers)).forEach(user -> {
            if (!this.userAccountService.exists(user)) {
                this.LOGGER.info("Creating technical user: {}", user);
                this.userAccountService.create(user);
            }
        });
    }
}

