/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.oauth;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.repository.oauth.AbstractOAuthProviderConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;

@Configuration
public class GithubOAuthProviderConfiguration
extends AbstractOAuthProviderConfiguration {
    private static final String LOGOUT_URL = "/logout";
    private String contextPath;

    public GithubOAuthProviderConfiguration(@Value(value="${github.oauth2.resource.userInfoUri}") String githubUserInfoEndpointUrl, @Value(value="${github.oauth2.client.clientId}") String githubClientId, @Value(value="${server.contextPath}") String contextPath) {
        super(new UserInfoTokenServices(githubUserInfoEndpointUrl, githubClientId));
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        this.contextPath = contextPath;
    }

    public String getFilterProcessingUrl() {
        return "github/login";
    }

    protected String getUserAttributeId() {
        return "login";
    }

    @Bean
    @ConfigurationProperties(value="github.oauth2.client")
    public AuthorizationCodeResourceDetails github() {
        return new AuthorizationCodeResourceDetails();
    }

    protected AuthorizationCodeResourceDetails createDetails() {
        return this.github();
    }

    public String getLogoutUrl(HttpServletRequest request) {
        return this.getBaseUrl(request) + this.contextPath + LOGOUT_URL;
    }

    private String getBaseUrl(HttpServletRequest request) {
        if (request.getRequestURI().equals("/") || request.getRequestURI().equals("")) {
            return request.getRequestURL().toString();
        }
        return request.getRequestURL().toString().replace(request.getRequestURI(), "");
    }

    public String getLogoHref() {
        return "webjars/repository-web/dist/images/github-social.png";
    }
}

