/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.client.impl;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.repository.client.IRepositoryClient;
import org.eclipse.vorto.repository.client.ModelContent;
import org.eclipse.vorto.repository.client.ModelInfo;
import org.eclipse.vorto.repository.client.ModelQueryException;
import org.eclipse.vorto.repository.client.RepositoryClientException;
import org.eclipse.vorto.repository.client.attachment.Attachment;
import org.eclipse.vorto.repository.client.generation.GeneratedOutput;
import org.eclipse.vorto.repository.client.generation.GeneratorInfo;
import org.eclipse.vorto.repository.client.generation.GeneratorUrlBuilder;
import org.eclipse.vorto.repository.client.impl.ImplementationBase;
import org.eclipse.vorto.repository.client.impl.RequestContext;

public class DefaultRepositoryClient
extends ImplementationBase
implements IRepositoryClient {
    private static final String REST_SEARCH_BASE = "api/v1/search/models";
    private static final String REST_MODEL_BASE = "api/v1/models";
    private static final String REST_ATTACHMENT_BASE = "api/v1/attachments";

    public DefaultRepositoryClient(HttpClient httpClient, RequestContext context) {
        super(httpClient, context);
    }

    @Override
    public Set<String> getAvailableGeneratorKeys() {
        return this.getAllGenerators(generators -> generators.stream().map(GeneratorInfo::getKey).collect(Collectors.toSet()));
    }

    @Override
    public GeneratorInfo getInfo(String generatorKey) {
        Objects.requireNonNull(generatorKey);
        return this.getAllGenerators(generators -> generators.stream().filter(generator -> generator.getKey().equals(generatorKey)).findFirst().orElse(null));
    }

    @Override
    public GeneratedOutput generate(ModelId modelId, String generatorKey, Map<String, String> invocationParams) {
        Objects.requireNonNull(modelId);
        Objects.requireNonNull(generatorKey);
        String generateUrl = GeneratorUrlBuilder.getGeneratorUrl(this.getRequestContext().getBaseUrl(), modelId, generatorKey, invocationParams);
        return this.requestAndTransform(generateUrl, this::getGeneratedOutput);
    }

    @Override
    public Collection<ModelInfo> search(String expression) {
        try {
            String url = String.format("%s/%s?expression=%s", this.getRequestContext().getBaseUrl(), String.format(REST_SEARCH_BASE, new Object[0]), URLEncoder.encode(expression, "utf-8"));
            return (Collection)this.requestAndTransform(url, this.transformToType(new TypeToken<ArrayList<ModelInfo>>(){}.getType()));
        }
        catch (UnsupportedEncodingException e) {
            throw new ModelQueryException("Error encoding the query", e);
        }
    }

    @Override
    public ModelInfo getById(ModelId modelId) {
        String url = String.format("%s/%s/%s", this.getRequestContext().getBaseUrl(), String.format(REST_MODEL_BASE, new Object[0]), modelId.getPrettyFormat());
        return this.requestAndTransform(url, this.transformToClass(ModelInfo.class));
    }

    @Override
    public ModelContent getContent(ModelId modelId) {
        String url = String.format("%s/%s/%s/content", this.getRequestContext().getBaseUrl(), String.format(REST_MODEL_BASE, new Object[0]), modelId.getPrettyFormat());
        return this.requestAndTransform(url, this.transformToClass(ModelContent.class));
    }

    @Override
    public ModelContent getContent(ModelId modelId, String targetPlatformKey) {
        String url = String.format("%s/%s/%s/content/%s", this.getRequestContext().getBaseUrl(), String.format(REST_MODEL_BASE, new Object[0]), modelId.getPrettyFormat(), targetPlatformKey);
        return this.requestAndTransform(url, this.transformToClass(ModelContent.class));
    }

    @Override
    public ModelContent getContent(ModelId modelId, ModelId mappingModelId) {
        String url = String.format("%s/%s/%s/content/mappings/%s", this.getRequestContext().getBaseUrl(), String.format(REST_MODEL_BASE, new Object[0]), modelId.getPrettyFormat(), mappingModelId.getPrettyFormat());
        return this.requestAndTransform(url, this.transformToClass(ModelContent.class));
    }

    @Override
    public List<Attachment> getAttachments(ModelId modelId) {
        String url = String.format("%s/%s/%s", this.getRequestContext().getBaseUrl(), String.format(REST_ATTACHMENT_BASE, new Object[0]), modelId.getPrettyFormat());
        return (List)this.requestAndTransform(url, this.transformToType(new TypeToken<ArrayList<Attachment>>(){}.getType()));
    }

    @Override
    public byte[] downloadAttachment(ModelId modelId, String filename) {
        String url = String.format("%s/%s/%s/files/%s", this.getRequestContext().getBaseUrl(), String.format(REST_ATTACHMENT_BASE, new Object[0]), modelId.getPrettyFormat(), filename);
        return this.requestAndTransform(url, response -> {
            try {
                return IOUtils.toByteArray((InputStream)response.getEntity().getContent());
            }
            catch (IOException | UnsupportedOperationException e) {
                throw new RepositoryClientException("Error while getting attachment + '" + filename + "' with url '" + url + "'", e);
            }
        });
    }

    private <K> K getAllGenerators(Function<List<GeneratorInfo>, K> converter) {
        Objects.requireNonNull(converter);
        String getAllGeneratorsUrl = GeneratorUrlBuilder.getAllGeneratorsUrl(this.getRequestContext().getBaseUrl());
        return (K)this.requestAndTransform(getAllGeneratorsUrl, converter.compose(this.transformToType(new TypeToken<ArrayList<GeneratorInfo>>(){}.getType())), () -> converter.apply(Collections.emptyList()));
    }

    private GeneratedOutput getGeneratedOutput(HttpResponse response) {
        try {
            String contentDisposition = response.getFirstHeader("Content-Disposition").getValue();
            String filename = contentDisposition.substring(contentDisposition.indexOf("filename = ") + "filename = ".length());
            long length = response.getEntity().getContentLength();
            byte[] content = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
            return new GeneratedOutput(content, filename, length);
        }
        catch (IOException e) {
            throw new RepositoryClientException("Error in converting response to GeneratedOutput", e);
        }
    }
}

