/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.client.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.vorto.model.AbstractModel;
import org.eclipse.vorto.model.BooleanAttributeProperty;
import org.eclipse.vorto.model.EntityModel;
import org.eclipse.vorto.model.EnumAttributeProperty;
import org.eclipse.vorto.model.EnumModel;
import org.eclipse.vorto.model.FunctionblockModel;
import org.eclipse.vorto.model.IPropertyAttribute;
import org.eclipse.vorto.model.IReferenceType;
import org.eclipse.vorto.model.Infomodel;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.PrimitiveType;
import org.eclipse.vorto.repository.client.RepositoryClientException;
import org.eclipse.vorto.repository.client.impl.RequestContext;

public class ImplementationBase {
    protected HttpClient httpClient;
    protected RequestContext requestContext;
    protected static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    protected Gson gson = new GsonBuilder().registerTypeAdapter(IReferenceType.class, (Object)new JsonDeserializer<IReferenceType>(){

        public IReferenceType deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (jsonElement.isJsonPrimitive()) {
                return PrimitiveType.valueOf((String)jsonElement.getAsString());
            }
            return (IReferenceType)context.deserialize(jsonElement, ModelId.class);
        }
    }).registerTypeAdapter(IPropertyAttribute.class, (Object)new JsonDeserializer<IPropertyAttribute>(){

        public IPropertyAttribute deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (jsonElement.getAsJsonObject().get("value").isJsonPrimitive()) {
                return (IPropertyAttribute)context.deserialize(jsonElement, BooleanAttributeProperty.class);
            }
            return (IPropertyAttribute)context.deserialize(jsonElement, EnumAttributeProperty.class);
        }
    }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return dateFormat.parse(json.getAsJsonPrimitive().getAsString());
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }).registerTypeAdapter(Map.class, (Object)new JsonDeserializer<HashMap<ModelId, AbstractModel>>(){

        public HashMap<ModelId, AbstractModel> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (!jsonElement.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Set jsonEntrySet = jsonObject.entrySet();
            HashMap<ModelId, AbstractModel> deserializedMap = new HashMap<ModelId, AbstractModel>();
            for (Map.Entry entry : jsonEntrySet) {
                AbstractModel value = null;
                if (((JsonElement)entry.getValue()).getAsJsonObject().has("type") && ((JsonElement)entry.getValue()).getAsJsonObject().get("type").getAsJsonPrimitive().getAsString().equals("InformationModel")) {
                    value = (AbstractModel)context.deserialize((JsonElement)entry.getValue(), Infomodel.class);
                } else if (((JsonElement)entry.getValue()).getAsJsonObject().has("type") && ((JsonElement)entry.getValue()).getAsJsonObject().get("type").getAsJsonPrimitive().getAsString().equals("Functionblock")) {
                    value = (AbstractModel)context.deserialize((JsonElement)entry.getValue(), FunctionblockModel.class);
                } else if (((JsonElement)entry.getValue()).getAsJsonObject().has("type") && ((JsonElement)entry.getValue()).getAsJsonObject().get("type").getAsJsonPrimitive().getAsString().equals("Datatype") && ((JsonElement)entry.getValue()).getAsJsonObject().has("literals")) {
                    value = (AbstractModel)context.deserialize((JsonElement)entry.getValue(), EnumModel.class);
                } else if (((JsonElement)entry.getValue()).getAsJsonObject().has("type") && ((JsonElement)entry.getValue()).getAsJsonObject().get("type").getAsJsonPrimitive().getAsString().equals("Datatype")) {
                    value = (AbstractModel)context.deserialize((JsonElement)entry.getValue(), EntityModel.class);
                }
                if (value == null) continue;
                deserializedMap.put(this.getModelId((String)entry.getKey()), value);
            }
            return deserializedMap;
        }

        private ModelId getModelId(String modelId) {
            try {
                return ModelId.fromPrettyFormat((String)modelId);
            }
            catch (IllegalArgumentException ex) {
                int versionIndex = modelId.indexOf(":");
                return ModelId.fromReference((String)modelId.substring(0, versionIndex), (String)modelId.substring(versionIndex + 1));
            }
        }
    }).create();

    public ImplementationBase(HttpClient httpClient, RequestContext requestContext) {
        this.httpClient = httpClient;
        this.requestContext = requestContext;
    }

    protected RequestContext getRequestContext() {
        return this.requestContext;
    }

    protected <K> Function<HttpResponse, K> transformToType(Type type) {
        return response -> {
            try {
                return this.gson.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8"), type);
            }
            catch (JsonSyntaxException | IOException e) {
                throw new RepositoryClientException("Error in converting result to " + type.getTypeName(), e);
            }
        };
    }

    protected <K> Function<HttpResponse, K> transformToClass(Class<K> modelClass) {
        return response -> {
            try {
                return this.gson.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8"), modelClass);
            }
            catch (JsonSyntaxException | IOException e) {
                throw new RepositoryClientException("Error in converting result to " + modelClass.getName(), e);
            }
        };
    }

    protected <K> K requestAndTransform(String url, Function<HttpResponse, K> successFn) {
        return (K)this.requestAndTransform(url, successFn, () -> null);
    }

    protected <K> K requestAndTransform(String url, Function<HttpResponse, K> successFn, Supplier<K> errorSupplier) {
        HttpGet query = new HttpGet(url);
        if (this.requestContext.getRequestConfig() != null) {
            query.setConfig(this.requestContext.getRequestConfig());
        }
        try {
            return (K)this.httpClient.execute((HttpUriRequest)query, response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 300) {
                    return successFn.apply(response);
                }
                return errorSupplier.get();
            });
        }
        catch (IOException e) {
            throw new RepositoryClientException("Error in executing URL : " + url, e);
        }
    }
}

