/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vorto.model.AbstractModel;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelType;

public class ModelInfo
extends AbstractModel {
    protected String author;
    protected Date creationDate;
    protected Date modificationDate;
    protected boolean hasImage = false;
    protected String state;
    protected Boolean imported = false;
    protected List<ModelId> referencedBy = new ArrayList<ModelId>();
    protected Map<String, ModelId> platformMappings = new HashMap<String, ModelId>();

    public ModelInfo(ModelId modelId, ModelType modelType) {
        super(modelId, modelType);
    }

    public ModelInfo(ModelId modelId, String type) {
        this(modelId, ModelType.valueOf((String)type));
    }

    public ModelInfo() {
    }

    public List<ModelId> getReferencedBy() {
        return this.referencedBy;
    }

    public void setReferencedBy(List<ModelId> referencedBy) {
        this.referencedBy = referencedBy;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public Map<String, ModelId> getPlatformMappings() {
        return this.platformMappings;
    }

    public void setPlatformMappings(Map<String, ModelId> platformMappings) {
        this.platformMappings = platformMappings;
    }

    public boolean isHasImage() {
        return this.hasImage;
    }

    public void setHasImage(boolean hasImage) {
        this.hasImage = hasImage;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String toString() {
        return "ModelInfo [ id =" + this.id + ", type=" + this.type + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ModelInfo other = (ModelInfo)((Object)obj);
        if (this.id == null ? other.id != null : !this.id.equals((Object)other.id)) {
            return false;
        }
        return this.type == other.type;
    }

    public void addPlatformMapping(String targetPlatform, ModelId mappingId) {
        if (targetPlatform != null && !targetPlatform.equals("")) {
            this.platformMappings.put(targetPlatform, mappingId);
        }
    }

    public void addReferencedBy(ModelId id) {
        this.referencedBy.add(id);
    }

    public boolean isReleased() {
        return "released".equalsIgnoreCase(this.state) || "deprecated".equalsIgnoreCase(this.state);
    }

    public Boolean getImported() {
        return this.imported;
    }

    public void setImported(Boolean imported) {
        this.imported = imported;
    }
}

