/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.vorto.repository.api.content.IMappedElement;
import org.eclipse.vorto.repository.api.impl.TextFilter;
import org.eclipse.vorto.repository.api.impl.XPathEvaluator;
import org.eclipse.vorto.repository.api.mapping.IMappingQuery;

public abstract class MappingQueryJxPath<Result extends IMappedElement>
implements IMappingQuery<Result> {
    private List<TextFilter> filters = new ArrayList<TextFilter>();

    protected void addFilter(TextFilter filter) {
        this.filters.add(filter);
    }

    public List<Result> list() {
        ArrayList<Object> params = new ArrayList<Object>();
        List<String> queries = this.getFilterQueries(this.filters, params);
        List<Object> result = new ArrayList<Result>(this.getAll());
        for (String query : queries) {
            XPathEvaluator evaluator = new XPathEvaluator();
            result = (List)evaluator.eval(query, result);
        }
        return result;
    }

    protected abstract Collection<Result> getAll();

    protected List<String> getFilterQueries(List<TextFilter> filters, List<Object> params) {
        ArrayList<String> queries = new ArrayList<String>();
        if (filters != null && !filters.isEmpty()) {
            for (TextFilter filter : filters) {
                String query = filter.getWhereCondition();
                for (Object parameter : filter.getParameters()) {
                    query = query.replaceFirst("\\?", parameter.toString());
                }
                queries.add(query);
                params.addAll(filter.getParameters());
            }
        } else {
            queries.add("/.");
        }
        return queries;
    }

    public int count() {
        return this.list().size();
    }

    public IMappingQuery<Result> stereotype(String name) {
        TextFilter tf = new TextFilter();
        tf.setKey("stereotype");
        tf.setText(name);
        tf.setWhereCondition("/.[stereotypes[name = '?']]");
        this.addFilter(tf);
        return this;
    }

    public IMappingQuery<Result> attribute(String key, String value) {
        TextFilter tf = new TextFilter();
        tf.setKey("attribute");
        tf.setText(value);
        tf.setWhereCondition(".[stereotypes/attributes[@name = '" + key + "'] = '?']");
        this.addFilter(tf);
        return this;
    }
}

