/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.client;

import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.vorto.repository.api.IModelGeneration;
import org.eclipse.vorto.repository.api.IModelRepository;
import org.eclipse.vorto.repository.api.impl.DefaultMappingClient;
import org.eclipse.vorto.repository.api.impl.DefaultModelGeneration;
import org.eclipse.vorto.repository.api.impl.DefaultModelRepository;
import org.eclipse.vorto.repository.api.mapping.IMapping;
import org.eclipse.vorto.repository.client.IRepositoryClient;
import org.eclipse.vorto.repository.client.impl.DefaultRepositoryClient;
import org.eclipse.vorto.repository.client.impl.RequestContext;

public class RepositoryClientBuilder {
    private String baseUrl = "http://vorto.eclipse.org";
    private String proxyHost;
    private int proxyPort = 8080;
    private String tenantId = null;

    public static RepositoryClientBuilder newBuilder() {
        return new RepositoryClientBuilder();
    }

    private RepositoryClientBuilder() {
    }

    public RepositoryClientBuilder setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public RepositoryClientBuilder setTenant(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public RepositoryClientBuilder setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public RepositoryClientBuilder setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    @Deprecated
    public IModelGeneration buildModelGenerationClient() {
        return new DefaultModelGeneration(this.buildHttpClient(), this.buildRequestContext());
    }

    @Deprecated
    public IModelRepository buildModelRepositoryClient() {
        return new DefaultModelRepository(this.buildHttpClient(), this.buildRequestContext());
    }

    @Deprecated
    public IMapping buildIMappingClient() {
        return new DefaultMappingClient();
    }

    private HttpClient buildHttpClient() {
        return HttpClients.createDefault();
    }

    private org.eclipse.vorto.repository.api.impl.RequestContext buildRequestContext() {
        if (this.hasProxy()) {
            return new org.eclipse.vorto.repository.api.impl.RequestContext(this.baseUrl, RequestConfig.custom().setProxy(new HttpHost(this.proxyHost, this.proxyPort)).build(), this.tenantId);
        }
        return new org.eclipse.vorto.repository.api.impl.RequestContext(this.baseUrl, RequestConfig.DEFAULT, this.tenantId);
    }

    private boolean hasProxy() {
        return this.proxyHost != null && !this.proxyHost.trim().isEmpty();
    }

    public IRepositoryClient build() {
        return new DefaultRepositoryClient(this.buildHttpClient(), this.buildRequestContext2());
    }

    private RequestContext buildRequestContext2() {
        if (this.hasProxy()) {
            return new RequestContext(this.baseUrl, RequestConfig.custom().setProxy(new HttpHost(this.proxyHost, this.proxyPort)).build());
        }
        return new RequestContext(this.baseUrl, RequestConfig.DEFAULT);
    }
}

