/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.api.impl;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.eclipse.vorto.repository.api.IModelRepository;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelQuery;
import org.eclipse.vorto.repository.api.attachment.Attachment;
import org.eclipse.vorto.repository.api.content.ModelContent;
import org.eclipse.vorto.repository.api.exception.ModelQueryException;
import org.eclipse.vorto.repository.api.impl.ImplementationBase;
import org.eclipse.vorto.repository.api.impl.RequestContext;
import org.eclipse.vorto.repository.client.RepositoryClientException;

public class DefaultModelRepository
extends ImplementationBase
implements IModelRepository {
    private static final String REST_SEARCH_BASE = "api/v1/search/models";
    private static final String REST_MODEL_BASE = "api/v1/models";
    private static final String REST_ATTACHMENT_BASE = "api/v1/attachments";

    public DefaultModelRepository(HttpClient httpClient, RequestContext requestContext) {
        super(httpClient, requestContext);
    }

    public CompletableFuture<Collection<ModelInfo>> search(ModelQuery query) {
        String expression = "*";
        if (query.getExpression() != null) {
            try {
                expression = URLEncoder.encode(query.getExpression().trim(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ModelQueryException("Error encoding the query", (Throwable)e);
            }
        }
        String url = String.format("%s/%s?expression=%s", this.getRequestContext().getBaseUrl(), REST_SEARCH_BASE, expression);
        return this.requestAndTransform(url, this.transformToType(new TypeToken<ArrayList<ModelInfo>>(){}.getType()));
    }

    public CompletableFuture<ModelInfo> getById(ModelId modelId) {
        String url = String.format("%s/%s/%s", this.getRequestContext().getBaseUrl(), REST_MODEL_BASE, modelId.getPrettyFormat());
        return this.requestAndTransform(url, this.transformToClass(ModelInfo.class));
    }

    public CompletableFuture<ModelContent> getContent(ModelId modelId) {
        String url = String.format("%s/%s/%s/content", this.getRequestContext().getBaseUrl(), REST_MODEL_BASE, modelId.getPrettyFormat());
        return this.requestAndTransform(url, this.transformToClass(ModelContent.class));
    }

    public CompletableFuture<ModelContent> getContent(ModelId modelId, String targetPlatformKey) {
        String url = String.format("%s/%s/%s/content/%s", this.getRequestContext().getBaseUrl(), REST_MODEL_BASE, modelId.getPrettyFormat(), targetPlatformKey);
        return this.requestAndTransform(url, this.transformToClass(ModelContent.class));
    }

    public CompletableFuture<ModelContent> getContent(ModelId modelId, ModelId mappingModelId) {
        String url = String.format("%s/%s/%s/content/mappings/%s", this.getRequestContext().getBaseUrl(), REST_MODEL_BASE, modelId.getPrettyFormat(), mappingModelId.getPrettyFormat());
        return this.requestAndTransform(url, this.transformToClass(ModelContent.class));
    }

    public CompletableFuture<List<Attachment>> getAttachments(ModelId modelId) {
        String url = String.format("%s/%s/%s", this.getRequestContext().getBaseUrl(), REST_ATTACHMENT_BASE, modelId.getPrettyFormat());
        return this.requestAndTransform(url, this.transformToType(new TypeToken<ArrayList<Attachment>>(){}.getType()));
    }

    public CompletableFuture<byte[]> getAttachment(ModelId modelId, String filename) {
        String url = String.format("%s/%s/%s/files/%s", this.getRequestContext().getBaseUrl(), REST_ATTACHMENT_BASE, modelId.getPrettyFormat(), filename);
        return this.requestAndTransform(url, response -> {
            try {
                return IOUtils.toByteArray((InputStream)response.getEntity().getContent());
            }
            catch (IOException | UnsupportedOperationException e) {
                throw new RepositoryClientException("Error while getting attachment + '" + filename + "' with url '" + url + "'", e);
            }
        });
    }
}

