/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.api.impl;

import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.http.client.HttpClient;
import org.eclipse.vorto.repository.api.IModel;
import org.eclipse.vorto.repository.api.IModelRepository;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelQuery;
import org.eclipse.vorto.repository.api.exception.ModelQueryException;
import org.eclipse.vorto.repository.api.impl.ImplementationBase;
import org.eclipse.vorto.repository.api.impl.RequestContext;

public class DefaultModelRepository
extends ImplementationBase
implements IModelRepository {
    public DefaultModelRepository(HttpClient httpClient, RequestContext requestContext) {
        super(httpClient, requestContext);
    }

    public CompletableFuture<Collection<ModelInfo>> search(ModelQuery query) {
        String expression = "*";
        if (query.getExpression() != null) {
            try {
                expression = URLEncoder.encode(query.getExpression().trim(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ModelQueryException("Error encoding the query", (Throwable)e);
            }
        }
        String url = String.format("%s/rest/model/query=%s", this.getRequestContext().getBaseUrl(), expression);
        return this.requestAndTransform(url, this.transformToType(new TypeToken<ArrayList<ModelInfo>>(){}.getType()));
    }

    public CompletableFuture<ModelInfo> getById(ModelId modelId) {
        String url = String.format("%s/rest/model/%s/%s/%s", this.getRequestContext().getBaseUrl(), modelId.getNamespace(), modelId.getName(), modelId.getVersion());
        return this.requestAndTransform(url, this.transformToClass(ModelInfo.class));
    }

    public <ModelContent extends IModel> CompletableFuture<ModelContent> getContent(ModelId modelId, Class<ModelContent> resultClass) {
        String url = String.format("%s/rest/model/content/%s/%s/%s", this.getRequestContext().getBaseUrl(), modelId.getNamespace(), modelId.getName(), modelId.getVersion());
        return this.requestAndTransform(url, this.transformToClass(resultClass));
    }

    public <ModelContent extends IModel> CompletableFuture<ModelContent> getContent(ModelId modelId, Class<ModelContent> resultClass, String targetPlatformKey) {
        String url = String.format("%s/rest/model/content/%s/%s/%s/mapping/%s", this.getRequestContext().getBaseUrl(), modelId.getNamespace(), modelId.getName(), modelId.getVersion(), targetPlatformKey);
        return this.requestAndTransform(url, this.transformToClass(resultClass));
    }

    public <ModelContent extends IModel> CompletableFuture<ModelContent> getContent(ModelId modelId, Class<ModelContent> resultClass, ModelId mappingModelId) {
        String url = String.format("%s/rest/model/content/%s/mapping/%s", this.getRequestContext().getBaseUrl(), modelId.getPrettyFormat(), mappingModelId.getPrettyFormat());
        return this.requestAndTransform(url, this.transformToClass(resultClass));
    }
}

