/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.api.impl;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;
import org.eclipse.vorto.repository.api.IModelPublisher;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.impl.ImplementationBase;
import org.eclipse.vorto.repository.api.impl.RequestContext;
import org.eclipse.vorto.repository.api.upload.ModelPublishException;
import org.eclipse.vorto.repository.api.upload.UploadModelResponse;
import org.eclipse.vorto.repository.api.upload.UploadModelResult;

public class DefaultModelPublisher
extends ImplementationBase
implements IModelPublisher {
    private String username;
    private String password;

    public DefaultModelPublisher(HttpClient httpClient, RequestContext requestContext, String username, String password) {
        super(httpClient, requestContext);
        this.username = username;
        this.password = password;
    }

    public ModelId publish(ModelType type, String content) throws ModelPublishException {
        String uploadModelsUrl = String.format("%s/rest/secure", this.getRequestContext().getBaseUrl());
        HttpPost query = new HttpPost(uploadModelsUrl);
        HttpEntity entity = MultipartEntityBuilder.create().addPart("fileName", (ContentBody)new StringBody("vortomodel" + type.getExtension(), ContentType.DEFAULT_TEXT)).addPart("fileDescription", (ContentBody)new StringBody("", ContentType.DEFAULT_TEXT)).addPart("file", (ContentBody)new ByteArrayBody(content.getBytes(), ContentType.APPLICATION_OCTET_STREAM, "vortomodel" + type.getExtension())).build();
        query.setEntity(entity);
        try {
            CompletableFuture response = this.execute((HttpUriRequest)query, new TypeToken<UploadModelResponse>(){}.getType());
            List result = ((UploadModelResponse)response.get()).getObj();
            if (((UploadModelResponse)response.get()).getIsSuccess().booleanValue()) {
                String checkinModelUrl = String.format("%s/rest/secure/%s", this.getRequestContext().getBaseUrl(), ((UploadModelResult)result.get(0)).getHandleId());
                HttpPut checkInModel = new HttpPut(checkinModelUrl);
                CompletableFuture checkedInResult = this.execute((HttpUriRequest)checkInModel, new TypeToken<ModelId>(){}.getType());
                return (ModelId)checkedInResult.get();
            }
            throw new ModelPublishException((UploadModelResult)result.get(0));
        }
        catch (Throwable ex) {
            if (!(ex instanceof ModelPublishException)) {
                throw new RuntimeException(ex);
            }
            throw (ModelPublishException)ex;
        }
    }

    public <Result> CompletableFuture<Result> execute(HttpUriRequest request, Type type) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                request.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes()));
                return this.httpClient.execute(request, response -> {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode >= 200 && statusCode <= 299) {
                        if (type.equals(Void.class)) {
                            return null;
                        }
                        String json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                        return this.gson.fromJson(json, type);
                    }
                    throw new RuntimeException("Error while executing async call, server respond with a status of:  " + response.getStatusLine().getStatusCode());
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Error executing async call to remote REST endpoint", e);
            }
        });
    }

    public <Result> CompletableFuture<Result> execute(HttpUriRequest request) {
        return this.execute(request, new TypeToken<Result>(){}.getType());
    }

    public void uploadModelImage(ModelId modelId, String imageBas64) throws ModelPublishException {
        String uploadImageUrl = String.format("%s/rest/model/image?namespace=%s&name=%s&version=%s", this.getRequestContext().getBaseUrl(), modelId.getNamespace(), modelId.getName(), modelId.getVersion());
        HttpPost uploadImage = new HttpPost(uploadImageUrl);
        HttpEntity entity = MultipartEntityBuilder.create().addPart("fileName", (ContentBody)new StringBody("vortomodel.png", ContentType.DEFAULT_TEXT)).addPart("fileDescription", (ContentBody)new StringBody("", ContentType.DEFAULT_TEXT)).addPart("file", (ContentBody)new ByteArrayBody(Base64.getDecoder().decode(imageBas64.getBytes()), ContentType.APPLICATION_OCTET_STREAM, "vortomodel.png")).build();
        uploadImage.setEntity(entity);
        try {
            this.execute((HttpUriRequest)uploadImage, new TypeToken<Void>(){}.getType());
        }
        catch (Throwable ex) {
            if (!(ex instanceof ModelPublishException)) {
                throw new RuntimeException(ex);
            }
            throw (ModelPublishException)ex;
        }
    }
}

