/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.client;

import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.vorto.repository.api.IModelGeneration;
import org.eclipse.vorto.repository.api.IModelPublisher;
import org.eclipse.vorto.repository.api.IModelRepository;
import org.eclipse.vorto.repository.api.IModelResolver;
import org.eclipse.vorto.repository.api.impl.DefaultMappingClient;
import org.eclipse.vorto.repository.api.impl.DefaultModelGeneration;
import org.eclipse.vorto.repository.api.impl.DefaultModelPublisher;
import org.eclipse.vorto.repository.api.impl.DefaultModelRepository;
import org.eclipse.vorto.repository.api.impl.DefaultModelResolver;
import org.eclipse.vorto.repository.api.impl.RequestContext;
import org.eclipse.vorto.repository.api.mapping.IMapping;

public class RepositoryClientBuilder {
    private String baseUrl = "http://vorto.eclipse.org";
    private String proxyHost;
    private int proxyPort = 8080;
    private String username;
    private String password;

    public static RepositoryClientBuilder newBuilder() {
        return new RepositoryClientBuilder();
    }

    private RepositoryClientBuilder() {
    }

    public RepositoryClientBuilder setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public RepositoryClientBuilder setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public RepositoryClientBuilder setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public RepositoryClientBuilder setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public IModelGeneration buildModelGenerationClient() {
        return new DefaultModelGeneration(this.buildHttpClient(), this.buildRequestContext());
    }

    public IModelRepository buildModelRepositoryClient() {
        return new DefaultModelRepository(this.buildHttpClient(), this.buildRequestContext());
    }

    public IModelPublisher buildModelPublishClient() {
        return new DefaultModelPublisher(this.buildHttpClient(), this.buildRequestContext(), this.username, this.password);
    }

    public IModelResolver buildModelResolverClient() {
        HttpClient client = this.buildHttpClient();
        RequestContext context = this.buildRequestContext();
        return new DefaultModelResolver(client, context, new DefaultModelRepository(client, context));
    }

    public IMapping buildIMappingClient() {
        return new DefaultMappingClient();
    }

    private HttpClient buildHttpClient() {
        return HttpClients.createDefault();
    }

    private RequestContext buildRequestContext() {
        if (this.hasProxy()) {
            return new RequestContext(this.baseUrl, RequestConfig.custom().setProxy(new HttpHost(this.proxyHost, this.proxyPort)).build());
        }
        return new RequestContext(this.baseUrl, RequestConfig.DEFAULT);
    }

    private boolean hasProxy() {
        return this.proxyHost != null && !this.proxyHost.trim().isEmpty();
    }
}

