/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.api.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.content.BooleanAttributeProperty;
import org.eclipse.vorto.repository.api.content.EnumAttributeProperty;
import org.eclipse.vorto.repository.api.content.IPropertyAttribute;
import org.eclipse.vorto.repository.api.content.IReferenceType;
import org.eclipse.vorto.repository.api.content.PrimitiveType;
import org.eclipse.vorto.repository.api.impl.RequestContext;
import org.eclipse.vorto.repository.client.RepositoryClientException;

public class ImplementationBase {
    private HttpClient httpClient;
    private RequestContext requestContext;
    private Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").registerTypeAdapter(IReferenceType.class, (Object)new JsonDeserializer<IReferenceType>(){

        public IReferenceType deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (jsonElement.isJsonPrimitive()) {
                return PrimitiveType.valueOf((String)jsonElement.getAsString());
            }
            return (IReferenceType)context.deserialize(jsonElement, ModelId.class);
        }
    }).registerTypeAdapter(IPropertyAttribute.class, (Object)new JsonDeserializer<IPropertyAttribute>(){

        public IPropertyAttribute deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (jsonElement.getAsJsonObject().get("value").isJsonPrimitive()) {
                return (IPropertyAttribute)context.deserialize(jsonElement, BooleanAttributeProperty.class);
            }
            return (IPropertyAttribute)context.deserialize(jsonElement, EnumAttributeProperty.class);
        }
    }).create();

    public ImplementationBase(HttpClient httpClient, RequestContext requestContext) {
        this.httpClient = httpClient;
        this.requestContext = requestContext;
    }

    protected RequestContext getRequestContext() {
        return this.requestContext;
    }

    protected <K> Function<HttpResponse, K> transformToType(Type type) {
        return response -> {
            try {
                return this.gson.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8"), type);
            }
            catch (JsonSyntaxException | IOException e) {
                throw new RepositoryClientException("Error in converting result to " + type.getTypeName(), e);
            }
        };
    }

    protected <K> Function<HttpResponse, K> transformToClass(Class<K> modelClass) {
        return response -> {
            try {
                return this.gson.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8"), modelClass);
            }
            catch (JsonSyntaxException | IOException e) {
                throw new RepositoryClientException("Error in converting result to " + modelClass.getName(), e);
            }
        };
    }

    protected <K> CompletableFuture<K> requestAndTransform(String url, Function<HttpResponse, K> successFn) {
        return this.requestAndTransform(url, successFn, () -> null);
    }

    protected <K> CompletableFuture<K> requestAndTransform(String url, Function<HttpResponse, K> successFn, Supplier<K> errorSupplier) {
        HttpGet query = new HttpGet(url);
        if (this.requestContext.getRequestConfig() != null) {
            query.setConfig(this.requestContext.getRequestConfig());
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.httpClient.execute((HttpUriRequest)query, arg_0 -> ImplementationBase.lambda$null$3(successFn, (Supplier)errorSupplier, arg_0));
            }
            catch (IOException e) {
                throw new RepositoryClientException("Error in executing URL : " + url, e);
            }
        });
    }

    private static /* synthetic */ Object lambda$null$3(Function successFn, Supplier errorSupplier, HttpResponse response) throws ClientProtocolException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return successFn.apply(response);
        }
        return errorSupplier.get();
    }
}

