/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.api.attachment;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.attachment.Tag;

public class Attachment {
    private ModelId modelId;
    private String filename;
    private List<Tag> tags = new ArrayList<Tag>();
    public static final Tag TAG_IMPORTED = new Tag("org.eclipse.vorto.tag.import", "Imported");
    public static final Tag TAG_DOCUMENTATION = new Tag("org.eclipse.vorto.tag.documentation", "Documentation");
    public static final Tag TAG_IMAGE = new Tag("org.eclipse.vorto.tag.image", "Image");

    public static Attachment newInstance(ModelId modelId, String filename) {
        return new Attachment(modelId, filename, Attachment.getLink(modelId, filename));
    }

    public static String getLink(ModelId modelId, String filename) {
        StringBuffer link = new StringBuffer("/api/v1/attachments");
        link.append("/");
        link.append(modelId.getPrettyFormat());
        link.append("/files/");
        link.append(filename);
        return link.toString();
    }

    private Attachment(ModelId modelId, String filename, String downloadLink) {
        this.modelId = modelId;
        this.filename = filename;
    }

    public ModelId getModelId() {
        return this.modelId;
    }

    public void setModelId(ModelId modelId) {
        this.modelId = modelId;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Optional<Tag> getTagById(String tagId) {
        return this.tags.stream().filter(tag -> tag.getId().equals(tagId)).findAny();
    }

    public String toString() {
        return "Attachment [modelId=" + this.modelId + ", filename=" + this.filename + ", tags=" + this.tags + "]";
    }
}

