/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.api.upload;

import java.util.Collection;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;

public class UploadModelResult {
    private String handleId = null;
    private ModelInfo modelResource = null;
    private boolean valid = false;
    private String errorMessage = null;
    private Collection<ModelId> unresolvedReferences;

    public UploadModelResult(String handleId, ModelInfo modelResource, boolean valid, String errorMessage) {
        this.handleId = handleId;
        this.modelResource = modelResource;
        this.valid = valid;
        this.errorMessage = errorMessage;
    }

    public UploadModelResult() {
    }

    public UploadModelResult(String handleId, ModelInfo modelResource, boolean valid, String errorMessage, Collection<ModelId> missingReferences) {
        this(handleId, modelResource, valid, errorMessage);
        this.unresolvedReferences = missingReferences;
    }

    public static UploadModelResult invalid(ModelInfo modelResource, String msg) {
        return new UploadModelResult(null, modelResource, false, msg);
    }

    public static UploadModelResult valid(String uploadHandle, ModelInfo modelResource) {
        return new UploadModelResult(uploadHandle, modelResource, true, null);
    }

    public static UploadModelResult valid(ModelInfo modelResource) {
        return new UploadModelResult(null, modelResource, true, null);
    }

    public ModelInfo getModelResource() {
        return this.modelResource;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getHandleId() {
        return this.handleId;
    }

    public Collection<ModelId> getUnresolvedReferences() {
        return this.unresolvedReferences;
    }

    public String toString() {
        return "UploadModelResult [handleId=" + this.handleId + ", modelResource=" + this.modelResource + ", valid=" + this.valid + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modelResource == null ? 0 : this.modelResource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UploadModelResult other = (UploadModelResult)obj;
        return !(this.modelResource == null ? other.modelResource != null : !this.modelResource.equals(other.modelResource));
    }
}

