/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.api;

import org.eclipse.vorto.repository.api.content.IReferenceType;

public class ModelId
implements IReferenceType {
    private String name;
    private String namespace;
    private String version;

    public ModelId() {
    }

    public ModelId(String name, String namespace, String version) {
        this.name = name;
        this.namespace = namespace.toLowerCase();
        this.version = version;
    }

    public static ModelId fromReference(String qualifiedName, String version) {
        String name = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
        String namespace = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
        return new ModelId(name, namespace, version);
    }

    public static ModelId fromPrettyFormat(String prettyFormat) {
        int versionIndex = prettyFormat.indexOf(":");
        return ModelId.fromReference(prettyFormat.substring(0, versionIndex), prettyFormat.substring(versionIndex + 1));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "ModelId [name=" + this.name + ", namespace=" + this.namespace + ", version=" + this.version + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelId other = (ModelId)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getPrettyFormat() {
        return this.namespace + "." + this.name + ":" + this.version;
    }
}

