/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.generator.utils.javatemplates;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Fault;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.ITemplate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaFunctionblockInterfaceTemplate
implements ITemplate<FunctionblockModel> {
    private String classPackage;
    private String interfacePrefix;
    private String[] imports;
    private ITemplate<Property> propertyTemplate;
    private ITemplate<Param> parameterTemplate;

    public JavaFunctionblockInterfaceTemplate(String classPackage, String interfacePrefix, String[] imports, ITemplate<Property> propertyTemplate, ITemplate<Param> parameterTemplate) {
        this.classPackage = classPackage;
        this.interfacePrefix = interfacePrefix;
        this.imports = imports;
        this.propertyTemplate = propertyTemplate;
        this.parameterTemplate = parameterTemplate;
    }

    @Override
    public String getContent(FunctionblockModel fbm, InvocationContext invocationContext) {
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*");
        _builder.newLine();
        _builder.append("*****************************************************************************************");
        _builder.newLine();
        _builder.append("* The present code has been generated by the Eclipse Vorto Java Code Generator.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* The basis for the generation was the Functionblock which is uniquely identified by:");
        _builder.newLine();
        _builder.append("* Name:\t\t\t");
        String _name = fbm.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("* Namespace:\t");
        String _namespace = fbm.getNamespace();
        _builder.append(_namespace);
        _builder.newLineIfNotEmpty();
        _builder.append("* Version:\t\t");
        String _version = fbm.getVersion();
        _builder.append(_version);
        _builder.newLineIfNotEmpty();
        _builder.append("*****************************************************************************************");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("package ");
        _builder.append(this.classPackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (String imprt : this.imports) {
            _builder.append("import ");
            _builder.append(imprt);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append("* ");
        String _description = fbm.getDescription();
        _builder.append(_description);
        _builder.newLineIfNotEmpty();
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public interface ");
        _builder.append(this.interfacePrefix);
        String _firstUpper = StringExtensions.toFirstUpper((String)fbm.getName());
        _builder.append(_firstUpper);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        FunctionBlock fb = fbm.getFunctionblock();
        _builder.append("\t");
        _builder.newLineIfNotEmpty();
        Status _status = fb.getStatus();
        boolean bl = _tripleNotEquals = _status != null;
        if (_tripleNotEquals) {
            _builder.append("\t");
            _builder.append("public ");
            String _name_1 = fbm.getName();
            _builder.append(_name_1, "\t");
            _builder.append("Status get");
            String _name_2 = fbm.getName();
            _builder.append(_name_2, "\t");
            _builder.append("Status();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        Configuration _configuration = fb.getConfiguration();
        boolean bl2 = _tripleNotEquals_1 = _configuration != null;
        if (_tripleNotEquals_1) {
            _builder.append("\t");
            _builder.append("public ");
            String _name_3 = fbm.getName();
            _builder.append(_name_3, "\t");
            _builder.append("Configuration get");
            String _name_4 = fbm.getName();
            _builder.append(_name_4, "\t");
            _builder.append("Configuration();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        Fault _fault = fb.getFault();
        boolean bl3 = _tripleNotEquals_2 = _fault != null;
        if (_tripleNotEquals_2) {
            _builder.append("\t");
            _builder.append("public ");
            String _name_5 = fbm.getName();
            _builder.append(_name_5, "\t");
            _builder.append("Fault get");
            String _name_6 = fbm.getName();
            _builder.append(_name_6, "\t");
            _builder.append("Fault();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        EList _operations = fb.getOperations();
        for (Operation op : _operations) {
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("* ");
            String _description_1 = op.getDescription();
            _builder.append(_description_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("*/");
            _builder.newLine();
            ReturnType _returnType = op.getReturnType();
            if (_returnType instanceof ReturnObjectType) {
                _builder.append("\t");
                ReturnType _returnType_1 = op.getReturnType();
                ReturnObjectType objectType = (ReturnObjectType)_returnType_1;
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("public ");
                String _name_7 = objectType.getReturnType().getName();
                _builder.append(_name_7, "\t");
                _builder.append(" ");
                String _name_8 = op.getName();
                _builder.append(_name_8, "\t");
                _builder.append("(");
                String _parameterString = this.getParameterString(op, invocationContext);
                _builder.append(_parameterString, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            } else {
                ReturnType _returnType_2 = op.getReturnType();
                if (_returnType_2 instanceof ReturnPrimitiveType) {
                    _builder.append("\t");
                    ReturnType _returnType_3 = op.getReturnType();
                    ReturnPrimitiveType primitiveType = (ReturnPrimitiveType)_returnType_3;
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("public ");
                    String _name_9 = primitiveType.getReturnType().getName();
                    _builder.append(_name_9, "\t");
                    _builder.append(" ");
                    String _name_10 = op.getName();
                    _builder.append(_name_10, "\t");
                    _builder.append("(");
                    String _parameterString_1 = this.getParameterString(op, invocationContext);
                    _builder.append(_parameterString_1, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("public void ");
                    String _name_11 = op.getName();
                    _builder.append(_name_11, "\t");
                    _builder.append("(");
                    String _parameterString_2 = this.getParameterString(op, invocationContext);
                    _builder.append(_parameterString_2, "\t");
                    _builder.append("); ");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("\t\t\t");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public String getParameterString(Operation op, InvocationContext invocationContext) {
        String result = "";
        EList _params = op.getParams();
        for (Param param : _params) {
            String _plus;
            String _content = this.parameterTemplate.getContent(param, invocationContext);
            result = _plus = result + ", " + _content;
        }
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)result);
        if (_isNullOrEmpty) {
            return "";
        }
        return result.substring(2, result.length()).replaceAll("\n", "").replaceAll("\r", "");
    }
}

