/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model;

import java.util.Arrays;
import java.util.List;
import org.eclipse.vorto.model.IReferenceType;

public class ModelId
implements IReferenceType {
    private String name;
    private String namespace;
    private String version;
    private static final List<ModelIdParser> parsers = Arrays.asList(new ModelIdParserOld(), new ModelIdParserNew());

    public ModelId() {
    }

    public ModelId(String name, String namespace, String version) {
        this.name = name;
        this.namespace = namespace.toLowerCase();
        this.version = version;
    }

    public static ModelId fromReference(String qualifiedName, String version) {
        String name = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
        String namespace = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
        return new ModelId(name, namespace, version);
    }

    public static ModelId fromPrettyFormat(String prettyFormat) {
        for (ModelIdParser parser : parsers) {
            if (!parser.canHandle(prettyFormat)) continue;
            return parser.parse(prettyFormat);
        }
        throw new IllegalArgumentException("Model ID is invalid. Must follow either pattern <namespace>:<name>:<version> or <namespace>.<name>:<version>");
    }

    public static ModelId newVersion(ModelId id, String newVersion) {
        return ModelId.fromPrettyFormat(id.getNamespace() + ":" + id.getName() + ":" + newVersion);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.getPrettyFormat();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelId other = (ModelId)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getPrettyFormat() {
        return this.namespace + ":" + this.name + ":" + this.version;
    }

    public static class ModelIdParserOld
    implements ModelIdParser {
        @Override
        public boolean canHandle(String modelId) {
            return modelId.split(":").length == 2;
        }

        @Override
        public ModelId parse(String modelId) {
            int versionIndex = modelId.indexOf(":");
            return ModelId.fromReference(modelId.substring(0, versionIndex), modelId.substring(versionIndex + 1));
        }
    }

    public static class ModelIdParserNew
    implements ModelIdParser {
        @Override
        public boolean canHandle(String modelId) {
            return modelId.split(":").length == 3;
        }

        @Override
        public ModelId parse(String modelId) {
            String[] tripleParts = modelId.split(":");
            return new ModelId(tripleParts[1], tripleParts[0], tripleParts[2]);
        }
    }

    private static interface ModelIdParser {
        public boolean canHandle(String var1);

        public ModelId parse(String var1);
    }
}

