/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model.runtime;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vorto.model.Infomodel;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.runtime.FunctionblockData;
import org.eclipse.vorto.model.runtime.IValidatable;
import org.eclipse.vorto.model.runtime.ValidationReport;

public class InfomodelData
implements IValidatable {
    private Infomodel meta = null;
    private Map<String, FunctionblockData> functionblocks = new HashMap<String, FunctionblockData>();

    public InfomodelData(Infomodel meta) {
        this.meta = meta;
    }

    public void withFunctionblock(FunctionblockData data) {
        this.functionblocks.put(data.getId(), data);
    }

    public Map<String, FunctionblockData> getProperties() {
        return this.functionblocks;
    }

    public FunctionblockData get(String fbProperty) {
        return this.functionblocks.get(fbProperty);
    }

    public String toString() {
        return "InfomodelData [functionblocks=" + this.functionblocks + "]";
    }

    @Override
    public ValidationReport validate() {
        ValidationReport report = new ValidationReport();
        for (ModelProperty fbProperty : this.meta.getFunctionblocks()) {
            if (fbProperty.isMandatory() && !this.functionblocks.containsKey(fbProperty.getName())) {
                report.addItem(fbProperty, "Mandatory property is missing!");
                continue;
            }
            FunctionblockData fbData = this.functionblocks.get(fbProperty.getName());
            if (fbData == null) continue;
            ValidationReport fbReport = fbData.validate();
            report.addReport(fbReport);
        }
        return report;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String fbProperty : this.functionblocks.keySet()) {
            result.put(fbProperty, this.functionblocks.get(fbProperty).serialize());
        }
        return result;
    }
}

