/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine.serializer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.vorto.mapping.engine.model.spec.IMappingSpecification;
import org.eclipse.vorto.mapping.engine.serializer.AbstractSerializer;
import org.eclipse.vorto.mapping.engine.serializer.MappingIdUtils;
import org.eclipse.vorto.model.EntityModel;
import org.eclipse.vorto.model.IModel;
import org.eclipse.vorto.model.IReferenceType;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.Stereotype;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class EntityMappingSerializer
extends AbstractSerializer {
    private IModel parent;
    private String propertyName;
    private EntityModel entity;

    public EntityMappingSerializer(IMappingSpecification spec, ModelId modelId, String targetPlatform, String propertyName, EntityModel entity, IModel parent) {
        super(spec, modelId, targetPlatform);
        this.parent = parent;
        this.propertyName = propertyName;
        this.entity = entity;
    }

    @Override
    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("vortolang 1.0");
        _builder.newLine();
        _builder.newLine();
        _builder.append("namespace ");
        String _namespace = this.modelId.getNamespace();
        _builder.append(_namespace);
        _builder.newLineIfNotEmpty();
        _builder.append("version ");
        String _version = this.modelId.getVersion();
        _builder.append(_version);
        _builder.newLineIfNotEmpty();
        _builder.append("displayname \"");
        String _firstUpper = StringExtensions.toFirstUpper((String)this.propertyName);
        _builder.append(_firstUpper);
        _builder.append(" Entity Payload Mapping\"");
        _builder.newLineIfNotEmpty();
        _builder.append("description \"Maps the ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)this.propertyName);
        _builder.append(_firstUpper_1);
        _builder.append(" payload of the ");
        String _prettyFormat = this.specification.getInfoModel().getId().getPrettyFormat();
        _builder.append(_prettyFormat);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("category payloadmapping");
        _builder.newLine();
        _builder.newLine();
        _builder.append("using ");
        String _namespace_1 = this.entity.getId().getNamespace();
        _builder.append(_namespace_1);
        _builder.append(".");
        String _name = this.entity.getId().getName();
        _builder.append(_name);
        _builder.append(";");
        String _version_1 = this.entity.getId().getVersion();
        _builder.append(_version_1);
        _builder.newLineIfNotEmpty();
        HashSet<ModelId> imports = new HashSet<ModelId>();
        _builder.newLineIfNotEmpty();
        List _properties = this.entity.getProperties();
        Iterator iterator = _properties.iterator();
        while (iterator.hasNext()) {
            ModelProperty property = (ModelProperty)iterator.next();
            boolean _isEntityProperty = this.isEntityProperty(property);
            if (!_isEntityProperty) continue;
            boolean x = imports.add(MappingIdUtils.getIdForProperty(this.parent.getId(), property));
            _builder.newLineIfNotEmpty();
        }
        for (ModelId using : imports) {
            _builder.append("using ");
            String _namespace_2 = using.getNamespace();
            _builder.append(_namespace_2);
            _builder.append(".");
            String _name_1 = using.getName();
            _builder.append(_name_1);
            _builder.append(";");
            String _version_2 = using.getVersion();
            _builder.append(_version_2);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("entitymapping ");
        String _name_2 = this.modelId.getName();
        _builder.append(_name_2);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("targetplatform ");
        _builder.append(this.targetPlatform, "\t");
        _builder.newLineIfNotEmpty();
        List _properties_1 = this.entity.getProperties();
        for (ModelProperty property_1 : _properties_1) {
            boolean _isEntityProperty_1 = this.isEntityProperty(property_1);
            if (_isEntityProperty_1) {
                _builder.append("\t");
                _builder.append("from ");
                String _name_3 = this.entity.getId().getName();
                _builder.append(_name_3, "\t");
                _builder.append(".");
                String _checkIfKeyword = this.checkIfKeyword(property_1.getName());
                _builder.append(_checkIfKeyword, "\t");
                _builder.append(" to reference ");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)property_1.getName());
                String _plus = _firstUpper_2 + "PayloadMapping";
                _builder.append(_plus, "\t");
                _builder.newLineIfNotEmpty();
                continue;
            }
            List<Stereotype> _filterEmptyStereotypes = this.filterEmptyStereotypes(property_1.getStereotypes());
            for (Stereotype stereotype : _filterEmptyStereotypes) {
                _builder.append("\t");
                _builder.append("from ");
                String _name_4 = this.entity.getId().getName();
                _builder.append(_name_4, "\t");
                _builder.append(".");
                String _checkIfKeyword_1 = this.checkIfKeyword(property_1.getName());
                _builder.append(_checkIfKeyword_1, "\t");
                _builder.append(" to ");
                String _name_5 = stereotype.getName();
                _builder.append(_name_5, "\t");
                _builder.append(" with {");
                String _createContent = this.createContent(stereotype.getAttributes());
                _builder.append(_createContent, "\t");
                _builder.append("}");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private List<Stereotype> filterEmptyStereotypes(List<Stereotype> stereotypes) {
        Predicate<Stereotype> _function = it -> {
            boolean _isEmpty = it.getAttributes().isEmpty();
            return !_isEmpty;
        };
        Predicate<Stereotype> _function_1 = it -> {
            boolean _isEmpty = this.getNonEmptyAttributes(it.getAttributes()).isEmpty();
            return !_isEmpty;
        };
        return stereotypes.stream().filter(_function).filter(_function_1).collect(Collectors.toList());
    }

    private HashMap<String, String> getNonEmptyAttributes(Map<String, String> attributes) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        Set<String> _keySet = attributes.keySet();
        for (String key : _keySet) {
            boolean _isEmpty = attributes.get(key).isEmpty();
            boolean _not = !_isEmpty;
            if (!_not) continue;
            newMap.put(key, attributes.get(key));
        }
        return newMap;
    }

    private String createContent(Map<String, String> attributes) {
        StringBuilder content = new StringBuilder();
        Iterator<String> iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if ((key.equalsIgnoreCase("xpath") || key.equalsIgnoreCase("condition")) && attributes.get(key).equals("")) continue;
            StringBuilder _append = content.append(key).append(":");
            String _escapeQuotes = this.escapeQuotes(attributes.get(key));
            String _plus = "\"" + _escapeQuotes;
            String _plus_1 = _plus + "\"";
            _append.append(_plus_1);
            boolean _hasNext = iter.hasNext();
            if (!_hasNext) continue;
            content.append(",");
        }
        return content.toString();
    }

    public String escapeQuotes(String value) {
        return StringEscapeUtils.escapeJava((String)value);
    }

    public boolean isEntityProperty(ModelProperty property) {
        IReferenceType _type = property.getType();
        return _type instanceof EntityModel;
    }
}

