/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine.serializer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.vorto.mapping.engine.model.spec.IMappingSpecification;
import org.eclipse.vorto.mapping.engine.serializer.AbstractSerializer;
import org.eclipse.vorto.mapping.engine.serializer.FunctionblockMappingSerializer;
import org.eclipse.vorto.mapping.engine.serializer.IMappingSerializer;
import org.eclipse.vorto.mapping.engine.serializer.InformationModelMappingSerializer;
import org.eclipse.vorto.model.ModelProperty;

public class MappingSpecificationSerializer {
    private IMappingSpecification specification;
    private String targetPlatform;

    private MappingSpecificationSerializer(IMappingSpecification specification, String targetPlatform) {
        this.specification = specification;
        this.targetPlatform = targetPlatform;
    }

    public static MappingSpecificationSerializer create(IMappingSpecification specification, String targetPlaform) {
        return new MappingSpecificationSerializer(specification, targetPlaform);
    }

    public Iterator<IMappingSerializer> iterator() {
        ArrayList<AbstractSerializer> serializers = new ArrayList<AbstractSerializer>();
        for (ModelProperty fbProperty : this.specification.getInfoModel().getFunctionblocks()) {
            serializers.add(new FunctionblockMappingSerializer(this.specification, this.targetPlatform, fbProperty.getName()));
        }
        serializers.add(new InformationModelMappingSerializer(this.specification, this.targetPlatform));
        return serializers.iterator();
    }
}

