/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine.serializer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.vorto.mapping.engine.model.spec.IMappingSpecification;
import org.eclipse.vorto.mapping.engine.serializer.AbstractSerializer;
import org.eclipse.vorto.model.FunctionblockModel;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.Operation;
import org.eclipse.vorto.model.Stereotype;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FunctionblockMappingSerializer
extends AbstractSerializer {
    private String propertyName;
    private FunctionblockModel fbm;

    public FunctionblockMappingSerializer(IMappingSpecification spec, String targetPlaform, String propertyName) {
        super(spec, targetPlaform);
        this.propertyName = propertyName;
        this.fbm = spec.getFunctionBlock(propertyName);
    }

    @Override
    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("namespace ");
        String _namespace = this.specification.getInfoModel().getId().getNamespace();
        _builder.append(_namespace);
        _builder.append(".mapping.fbs");
        _builder.newLineIfNotEmpty();
        _builder.append("version 1.0.0");
        _builder.newLine();
        _builder.append("displayname \"");
        _builder.append(this.propertyName);
        _builder.append("PayloadMapping\"");
        _builder.newLineIfNotEmpty();
        _builder.append("description \"");
        String _firstUpper = StringExtensions.toFirstUpper((String)this.targetPlatform.toLowerCase());
        _builder.append(_firstUpper);
        _builder.append(" Payload Mapping for the ");
        _builder.append(this.propertyName);
        _builder.append(" property of the ");
        String _displayName = this.specification.getInfoModel().getDisplayName();
        _builder.append(_displayName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("category payloadmapping");
        _builder.newLine();
        _builder.newLine();
        _builder.append("using ");
        String _namespace_1 = this.fbm.getId().getNamespace();
        _builder.append(_namespace_1);
        _builder.append(".");
        String _name = this.fbm.getId().getName();
        _builder.append(_name);
        _builder.append(";");
        String _version = this.fbm.getId().getVersion();
        _builder.append(_version);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("functionblockmapping ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)this.propertyName);
        _builder.append(_firstUpper_1);
        _builder.append("PayloadMapping");
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)this.targetPlatform.toLowerCase());
        _builder.append(_firstUpper_2);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("targetplatform ");
        _builder.append(this.targetPlatform, "\t");
        _builder.newLineIfNotEmpty();
        if (this.specification.getFunctionBlock(this.propertyName).getStereotype("functions").isPresent() && !((Stereotype)this.specification.getFunctionBlock(this.propertyName).getStereotype("functions").get()).getAttributes().isEmpty()) {
            _builder.append("\t");
            _builder.append("from ");
            String _name_1 = this.fbm.getId().getName();
            _builder.append(_name_1, "\t");
            _builder.append(" to functions with {");
            String _createFunctions = this.createFunctions((Stereotype)this.specification.getFunctionBlock(this.propertyName).getStereotype("functions").get());
            _builder.append(_createFunctions, "\t");
            _builder.append("}");
            _builder.newLineIfNotEmpty();
        }
        List _stereotypes = this.specification.getFunctionBlock(this.propertyName).getStereotypes();
        for (Stereotype stereotype : _stereotypes) {
            boolean _equalsIgnoreCase = stereotype.getName().equalsIgnoreCase("functions");
            boolean _not = !_equalsIgnoreCase;
            if (!_not) continue;
            _builder.append("\t");
            _builder.append("from ");
            String _name_2 = this.fbm.getId().getName();
            _builder.append(_name_2, "\t");
            _builder.append(" to ");
            String _name_3 = stereotype.getName();
            _builder.append(_name_3, "\t");
            _builder.append(" with {");
            String _createContent = this.createContent(stereotype.getAttributes());
            _builder.append(_createContent, "\t");
            _builder.append("}");
            _builder.newLineIfNotEmpty();
        }
        List _statusProperties = this.fbm.getStatusProperties();
        for (ModelProperty statusProperty : _statusProperties) {
            List<Stereotype> _filterEmptyStereotypes = this.filterEmptyStereotypes(statusProperty.getStereotypes());
            for (Stereotype stereotype_1 : _filterEmptyStereotypes) {
                _builder.append("\t");
                _builder.append("from ");
                String _name_4 = this.fbm.getId().getName();
                _builder.append(_name_4, "\t");
                _builder.append(".status.");
                String _name_5 = statusProperty.getName();
                _builder.append(_name_5, "\t");
                _builder.append(" to ");
                String _name_6 = stereotype_1.getName();
                _builder.append(_name_6, "\t");
                _builder.append(" with {");
                String _createContent_1 = this.createContent(stereotype_1.getAttributes());
                _builder.append(_createContent_1, "\t");
                _builder.append("}");
                _builder.newLineIfNotEmpty();
            }
        }
        List _configurationProperties = this.fbm.getConfigurationProperties();
        for (ModelProperty configProperty : _configurationProperties) {
            List<Stereotype> _filterEmptyStereotypes_1 = this.filterEmptyStereotypes(configProperty.getStereotypes());
            for (Stereotype stereotype_2 : _filterEmptyStereotypes_1) {
                _builder.append("\t");
                _builder.append("from ");
                String _name_7 = this.fbm.getId().getName();
                _builder.append(_name_7, "\t");
                _builder.append(".configuration.");
                String _name_8 = configProperty.getName();
                _builder.append(_name_8, "\t");
                _builder.append(" to ");
                String _name_9 = stereotype_2.getName();
                _builder.append(_name_9, "\t");
                _builder.append(" with {");
                String _createContent_2 = this.createContent(stereotype_2.getAttributes());
                _builder.append(_createContent_2, "\t");
                _builder.append("}");
                _builder.newLineIfNotEmpty();
            }
        }
        List _operations = this.fbm.getOperations();
        for (Operation operation : _operations) {
            List<Stereotype> _filterEmptyStereotypes_2 = this.filterEmptyStereotypes(operation.getStereotypes());
            for (Stereotype stereotype_3 : _filterEmptyStereotypes_2) {
                _builder.append("\t");
                _builder.append("from ");
                String _name_10 = this.fbm.getId().getName();
                _builder.append(_name_10, "\t");
                _builder.append(".operations.");
                String _name_11 = operation.getName();
                _builder.append(_name_11, "\t");
                _builder.append(" to ");
                String _name_12 = stereotype_3.getName();
                _builder.append(_name_12, "\t");
                _builder.append(" with {");
                String _createContent_3 = this.createContent(stereotype_3.getAttributes());
                _builder.append(_createContent_3, "\t");
                _builder.append("}");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private String createFunctions(Stereotype functionsStereotype) {
        StringBuilder content = new StringBuilder();
        Iterator iter = functionsStereotype.getAttributes().keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            boolean _equals = "_namespace".equals(key);
            boolean _not = !_equals;
            if (!_not) continue;
            StringBuilder _append = content.append(key).append(":");
            String _escapeQuotes = this.escapeQuotes((String)functionsStereotype.getAttributes().get(key));
            String _plus = "\"" + _escapeQuotes;
            String _plus_1 = _plus + "\"";
            _append.append(_plus_1);
            boolean _hasNext = iter.hasNext();
            if (!_hasNext) continue;
            content.append(",");
        }
        return content.toString();
    }

    public String escapeQuotes(String value) {
        return StringEscapeUtils.escapeJava((String)value);
    }

    private List<Stereotype> filterEmptyStereotypes(List<Stereotype> stereotypes) {
        Predicate<Stereotype> _function = it -> {
            boolean _isEmpty = it.getAttributes().isEmpty();
            return !_isEmpty;
        };
        Predicate<Stereotype> _function_1 = it -> {
            boolean _isEmpty = this.getNonEmptyAttributes(it.getAttributes()).isEmpty();
            return !_isEmpty;
        };
        return stereotypes.stream().filter(_function).filter(_function_1).collect(Collectors.toList());
    }

    private HashMap<String, String> getNonEmptyAttributes(Map<String, String> attributes) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        Set<String> _keySet = attributes.keySet();
        for (String key : _keySet) {
            boolean _isEmpty = attributes.get(key).isEmpty();
            boolean _not = !_isEmpty;
            if (!_not) continue;
            newMap.put(key, attributes.get(key));
        }
        return newMap;
    }

    private String createContent(Map<String, String> attributes) {
        StringBuilder content = new StringBuilder();
        Iterator<String> iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if ((key.equalsIgnoreCase("xpath") || key.equalsIgnoreCase("condition")) && attributes.get(key).equals("")) continue;
            StringBuilder _append = content.append(key).append(":");
            String _escapeQuotes = this.escapeQuotes(attributes.get(key));
            String _plus = "\"" + _escapeQuotes;
            String _plus_1 = _plus + "\"";
            _append.append(_plus_1);
            boolean _hasNext = iter.hasNext();
            if (!_hasNext) continue;
            content.append(",");
        }
        return content.toString();
    }

    @Override
    public ModelId getModelId() {
        String _firstUpper = StringExtensions.toFirstUpper((String)this.propertyName);
        String _plus = _firstUpper + "PayloadMapping";
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)this.targetPlatform.toLowerCase());
        String _plus_1 = _plus + _firstUpper_1;
        String _namespace = this.specification.getInfoModel().getId().getNamespace();
        String _plus_2 = _namespace + ".mapping.fbs";
        return new ModelId(_plus_1, _plus_2, "1.0.0");
    }
}

