/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.serializer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.service.mapping.internal.serializer.AbstractSerializer;
import org.eclipse.vorto.service.mapping.internal.serializer.FunctionblockMappingSerializer;
import org.eclipse.vorto.service.mapping.internal.serializer.InformationModelMappingSerializer;
import org.eclipse.vorto.service.mapping.serializer.IMappingSerializer;
import org.eclipse.vorto.service.mapping.spec.IMappingSpecification;

public class MappingSpecificationSerializer {
    private IMappingSpecification specification;

    private MappingSpecificationSerializer(IMappingSpecification specification) {
        this.specification = specification;
    }

    public static MappingSpecificationSerializer create(IMappingSpecification specification) {
        return new MappingSpecificationSerializer(specification);
    }

    public Iterator<IMappingSerializer> iterator() {
        ArrayList<AbstractSerializer> serializers = new ArrayList<AbstractSerializer>();
        for (ModelProperty fbProperty : this.specification.getInfoModel().getFunctionblocks()) {
            serializers.add(new FunctionblockMappingSerializer(this.specification, fbProperty.getName()));
        }
        serializers.add(new InformationModelMappingSerializer(this.specification));
        return serializers.iterator();
    }
}

