/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.internal.ditto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vorto.service.mapping.ditto.Feature;
import org.eclipse.vorto.service.mapping.internal.ditto.FeatureBuilder;

@JsonIgnoreProperties(value={"id", "content"})
public class FeatureImpl
implements Feature {
    private String id;
    private Map<String, Object> content = new HashMap<String, Object>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public FeatureImpl(String id) {
        this.id = id;
        this.content.put("properties", this.properties);
    }

    public FeatureImpl(String id, Map<String, Object> content) {
        this.id = id;
        this.content = content;
        this.properties.putAll((Map)this.content.get("properties"));
    }

    protected FeatureImpl() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public static FeatureBuilder newBuilder(String featureId) {
        return new FeatureBuilder(featureId);
    }

    @Override
    @JsonGetter(value="properties")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getStatusProperties() {
        if (this.properties.containsKey("status")) {
            return Collections.unmodifiableMap((Map)this.properties.get("status"));
        }
        return Collections.unmodifiableMap(Collections.emptyMap());
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getConfigurationProperties() {
        if (this.properties.containsKey("config")) {
            return Collections.unmodifiableMap((Map)this.properties.get("config"));
        }
        return Collections.unmodifiableMap(Collections.emptyMap());
    }
}

