/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.jxpath.JXPathContext;
import org.eclipse.vorto.service.mapping.internal.JxPathFactory;

public class DynamicBean {
    private Map<String, Object> properties = new HashMap<String, Object>();
    private JxPathFactory jxpathFactory;

    public DynamicBean(JxPathFactory jxpathFactory) {
        this.jxpathFactory = jxpathFactory;
    }

    public DynamicBean() {
        this(DynamicBean.defaultContext());
    }

    private static JxPathFactory defaultContext() {
        JxPathFactory factory = new JxPathFactory();
        factory.setLenient(true);
        return factory;
    }

    public void setProperty(String path, Object value) {
        this.setProperty(this.properties, path, value, path);
    }

    private void setProperty(Map<String, Object> bean, String currentPath, Object value, String path) {
        StringTokenizer tokenizer = new StringTokenizer(currentPath, "/");
        while (tokenizer.hasMoreTokens()) {
            String pathElement = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                Map newBean = null;
                if (this.isArray(pathElement)) {
                    String arrayName = this.getArrayName(pathElement);
                    if (!bean.containsKey(arrayName)) {
                        ArrayList array = new ArrayList();
                        bean.put(arrayName, array);
                        newBean = new HashMap();
                        array.add(newBean);
                    } else {
                        Object existingNode = this.getValue(bean, pathElement);
                        if (existingNode != null) {
                            newBean = (Map)existingNode;
                        } else {
                            List array = (List)bean.get(arrayName);
                            newBean = new HashMap();
                            array.add(newBean);
                        }
                    }
                } else if (bean.containsKey(pathElement)) {
                    newBean = (Map)bean.get(pathElement);
                } else {
                    newBean = new HashMap();
                    bean.put(pathElement, newBean);
                }
                this.setProperty(newBean, currentPath.substring(currentPath.indexOf("/") + 1), value, path);
                break;
            }
            bean.put(pathElement, value);
        }
    }

    private boolean isArray(String pathElement) {
        return pathElement.endsWith("]");
    }

    private String getArrayName(String pathElement) {
        return pathElement.substring(0, pathElement.indexOf("["));
    }

    private Object getValue(Object ctx, String path) {
        JXPathContext jxpathCtx = this.jxpathFactory.newContext(ctx);
        return jxpathCtx.getValue(path);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String toString() {
        return this.properties.toString();
    }

    public Map<String, Object> asMap() {
        return this.properties;
    }
}

