/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.ble;

import java.util.Optional;
import java.util.UUID;
import org.eclipse.vorto.repository.api.content.BooleanAttributeProperty;
import org.eclipse.vorto.repository.api.content.BooleanAttributePropertyType;
import org.eclipse.vorto.repository.api.content.FunctionblockModel;
import org.eclipse.vorto.repository.api.content.IPropertyAttribute;
import org.eclipse.vorto.repository.api.content.Infomodel;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.repository.api.content.Stereotype;
import org.eclipse.vorto.service.mapping.ble.BleGattCharacteristic;
import org.eclipse.vorto.service.mapping.ble.BleGattDevice;
import org.eclipse.vorto.service.mapping.ble.BleGattInitSequenceElement;
import org.eclipse.vorto.service.mapping.ble.BleGattService;
import org.eclipse.vorto.service.mapping.spec.IMappingSpecification;

public class BleGattDeviceBuilder {
    private BleGattDevice device;
    private Infomodel infomodel;
    private IMappingSpecification mappingSpec;

    public static BleGattDeviceBuilder newBuilder() {
        return new BleGattDeviceBuilder();
    }

    public BleGattDeviceBuilder withSpecification(IMappingSpecification mappingSpec) {
        this.infomodel = mappingSpec.getInfoModel();
        this.mappingSpec = mappingSpec;
        return this;
    }

    public BleGattDevice build() {
        this.device = new BleGattDevice();
        for (ModelProperty fbprop : this.infomodel.getFunctionblocks()) {
            BleGattCharacteristic ch;
            String uuid;
            FunctionblockModel fb = this.mappingSpec.getFunctionBlock(fbprop.getName());
            if (!"blegatt".equals(fb.getTargetPlatformKey())) continue;
            BleGattService service = new BleGattService();
            Optional stereotype = fb.getStereotype("source");
            if (stereotype.isPresent() && (uuid = (String)((Stereotype)stereotype.get()).getAttributes().get("uuid")) != null) {
                service.setUuid(UUID.fromString(uuid));
            }
            for (ModelProperty prop : fb.getConfigurationProperties()) {
                ch = this.buildCharacteristic(prop);
                if (ch.getUuid() == null) continue;
                service.addCharacteristics(ch);
            }
            for (ModelProperty prop : fb.getStatusProperties()) {
                ch = this.buildCharacteristic(prop);
                if (ch.getUuid() == null) continue;
                service.addCharacteristics(ch);
            }
            this.device.addService(service);
        }
        return this.device;
    }

    private BleGattCharacteristic buildCharacteristic(ModelProperty property) {
        BleGattCharacteristic ch = new BleGattCharacteristic();
        for (IPropertyAttribute attr : property.getAttributes()) {
            BooleanAttributeProperty attrprop;
            if (!(attr instanceof BooleanAttributeProperty) || (attrprop = (BooleanAttributeProperty)attr).getType() != BooleanAttributePropertyType.EVENTABLE || !attrprop.isValue()) continue;
            ch.setNotified(true);
        }
        Optional sourceSt = property.getStereotype("source");
        if (sourceSt.isPresent()) {
            Stereotype source = (Stereotype)sourceSt.get();
            if (source.getAttributes().containsKey("uuid")) {
                ch.setUuid(UUID.fromString(((String)source.getAttributes().get("uuid")).toString()));
            }
            if (source.getAttributes().containsKey("onConnect")) {
                BleGattInitSequenceElement elt = new BleGattInitSequenceElement(ch, (String)source.getAttributes().get("onConnect"));
                this.device.addInitSequenceElement(elt);
            }
            if (source.getAttributes().containsKey("handle")) {
                ch.setHandle((String)source.getAttributes().get("handle"));
            }
        }
        return ch;
    }
}

