/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.ble;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import org.eclipse.vorto.service.mapping.ble.BleGattCharacteristic;
import org.eclipse.vorto.service.mapping.ble.BleGattInitSequenceElement;
import org.eclipse.vorto.service.mapping.ble.BleGattService;

public class BleGattDevice {
    private Map<UUID, BleGattService> services = new HashMap<UUID, BleGattService>();
    private Map<String, BleGattCharacteristic> characteristics = new HashMap<String, BleGattCharacteristic>();
    private String modelNumber;
    private List<BleGattInitSequenceElement> initSequence = new Vector<BleGattInitSequenceElement>();

    public Map<UUID, BleGattService> getServices() {
        return this.services;
    }

    public void addService(BleGattService service) {
        this.services.put(service.getUuid(), service);
        for (BleGattCharacteristic ch : service.getCharacteristics().values()) {
            this.addCharacteristic(ch);
        }
    }

    public void setServices(Map<UUID, BleGattService> services) {
        this.services = services;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
    }

    public void addCharacteristic(BleGattCharacteristic characteristic) {
        this.characteristics.put(characteristic.getUuid().toString(), characteristic);
    }

    public Map<String, BleGattCharacteristic> getCharacteristics() {
        return this.characteristics;
    }

    public void setCharacteristics(Map<String, BleGattCharacteristic> characteristics) {
        this.characteristics = characteristics;
    }

    public void addInitSequenceElement(BleGattInitSequenceElement elt) {
        this.initSequence.add(elt);
    }

    public List<BleGattInitSequenceElement> getInitSequence() {
        return this.initSequence;
    }

    public boolean isNotificationComplete() {
        boolean result = true;
        for (BleGattCharacteristic ch : this.characteristics.values()) {
            if (!ch.isNotified()) continue;
            result &= ch.isUpdated();
        }
        return result;
    }
}

