/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine.converter;

import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.commons.jxpath.BasicNodeSet;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.JXPathInvalidAccessException;
import org.apache.commons.jxpath.util.TypeUtils;

public class JavascriptEvalFunction
implements Function {
    private String functionName;
    private String functionBody;

    public JavascriptEvalFunction(String funcName, String funcBody) {
        this.functionName = funcName;
        this.functionBody = funcBody;
    }

    public Object invoke(ExpressionContext context, Object[] parameters) {
        NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
        ScriptEngine engine = factory.getScriptEngine(new ClassFilter(){

            public boolean exposeToScripts(String s) {
                return false;
            }
        });
        try {
            Bindings bindings = engine.getBindings(100);
            bindings.remove("print");
            bindings.remove("load");
            bindings.remove("loadWithNewGlobal");
            bindings.remove("exit");
            bindings.remove("quit");
            engine.eval(this.functionBody);
        }
        catch (ScriptException e) {
            throw new JXPathException("Problem evaluating " + this.functionName, (Throwable)e);
        }
        Invocable inv = (Invocable)((Object)engine);
        int pi = 0;
        Class<?>[] types = this.toTypes(parameters);
        if (types.length >= 1 && ExpressionContext.class.isAssignableFrom(types[0])) {
            pi = 1;
        }
        Object[] args = new Object[parameters.length + pi];
        if (pi == 1) {
            args[0] = context;
        }
        for (int i = 0; i < parameters.length; ++i) {
            args[i + pi] = TypeUtils.convert((Object)parameters[i], types[i + pi]);
        }
        try {
            return inv.invokeFunction(this.functionName, this.unwrap(args));
        }
        catch (NoSuchMethodException e) {
            throw new JXPathInvalidAccessException("Cannot find function with the list of parameters", (Throwable)e);
        }
        catch (ScriptException e) {
            throw new JXPathInvalidAccessException("Problem executing javascript", (Throwable)e);
        }
    }

    private Object[] unwrap(Object[] wrappedArgs) {
        ArrayList<Object> unwrapped = new ArrayList<Object>();
        for (Object o : wrappedArgs) {
            if (o instanceof List) {
                List args = (List)o;
                unwrapped.add(args.get(0));
                continue;
            }
            unwrapped.add(o);
        }
        return unwrapped.toArray();
    }

    private Class<?>[] toTypes(Object[] parameters) {
        ArrayList<Class<Object>> result = new ArrayList<Class<Object>>();
        for (Object param : parameters) {
            if (param instanceof BasicNodeSet) {
                BasicNodeSet nodeSet = (BasicNodeSet)param;
                if (nodeSet.getPointers().size() > 1) {
                    result.add(Object[].class);
                    continue;
                }
                result.add(Object.class);
                continue;
            }
            result.add(Object.class);
        }
        return result.toArray(new Class[parameters.length]);
    }
}

