/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono;

import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.GeneratorInfo;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenProgressMonitor;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.api.VortoCodeGeneratorException;
import org.eclipse.vorto.codegen.hono.arduino.ArduinoCodeGenerator;
import org.eclipse.vorto.codegen.hono.java.EclipseHonoJavaGenerator;
import org.eclipse.vorto.codegen.hono.python.PythonGenerator;
import org.eclipse.vorto.codegen.utils.GenerationResultBuilder;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class EclipseHonoGenerator
implements IVortoCodeGenerator {
    public IGenerationResult generate(InformationModel model, InvocationContext context, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        GenerationResultZip output = new GenerationResultZip(model, this.getServiceKey());
        GenerationResultBuilder result = GenerationResultBuilder.from((IGenerationResult)output);
        String platform = context.getConfigurationProperties().getOrDefault("language", "java");
        if (platform.equalsIgnoreCase("arduino")) {
            result.append(this.generateArduino(model, context, monitor));
        } else if (platform.equalsIgnoreCase("python")) {
            result.append(this.generatePython(model, context, monitor));
        } else {
            result.append(this.generateJava(model, context, monitor));
        }
        return output;
    }

    private IGenerationResult generateJava(InformationModel infomodel, InvocationContext context, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        EclipseHonoJavaGenerator javaGenerator = new EclipseHonoJavaGenerator();
        return javaGenerator.generate(infomodel, context, monitor);
    }

    private IGenerationResult generatePython(InformationModel infomodel, InvocationContext context, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        PythonGenerator pythonGenerator = new PythonGenerator();
        return pythonGenerator.generate(infomodel, context, monitor);
    }

    private IGenerationResult generateArduino(InformationModel infomodel, InvocationContext context, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        ArduinoCodeGenerator arduinoGenerator = new ArduinoCodeGenerator();
        return arduinoGenerator.generate(infomodel, context, monitor);
    }

    public String getServiceKey() {
        return "eclipsehono";
    }

    public GeneratorInfo getInfo() {
        return GeneratorInfo.basicInfo((String)"Eclipse Hono", (String)"Generates device code (Arduino, Python, Java) that integrates with Eclipse Hono and Eclipse Ditto.", (String)"Eclipse Vorto Team").production().withChoiceConfigurationItem("language", "Device Platform", new GeneratorInfo.ChoiceItem[]{GeneratorInfo.ChoiceItem.of((String)"Arduino (ESP8266)", (String)"Arduino"), GeneratorInfo.ChoiceItem.of((String)"Python (v2)", (String)"Python"), GeneratorInfo.ChoiceItem.of((String)"Java", (String)"Java")});
    }
}

