/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java;

import org.eclipse.vorto.codegen.hono.java.AppTemplate;
import org.eclipse.vorto.codegen.hono.java.Log4jTemplate;
import org.eclipse.vorto.codegen.hono.java.PomFileTemplate;
import org.eclipse.vorto.codegen.hono.java.model.FunctionblockTemplate;
import org.eclipse.vorto.codegen.hono.java.model.InformationModelTemplate;
import org.eclipse.vorto.codegen.hono.java.model.JavaClassGeneratorTask;
import org.eclipse.vorto.codegen.hono.java.model.JavaEnumGeneratorTask;
import org.eclipse.vorto.codegen.hono.java.service.IDataServiceTemplate;
import org.eclipse.vorto.codegen.hono.java.service.hono.HonoDataService;
import org.eclipse.vorto.codegen.hono.java.service.hono.HonoMqttClientTemplate;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.plugin.generator.GeneratorException;
import org.eclipse.vorto.plugin.generator.GeneratorPluginInfo;
import org.eclipse.vorto.plugin.generator.ICodeGenerator;
import org.eclipse.vorto.plugin.generator.IGenerationResult;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.ChainedCodeGeneratorTask;
import org.eclipse.vorto.plugin.generator.utils.GenerationResultBuilder;
import org.eclipse.vorto.plugin.generator.utils.GenerationResultZip;
import org.eclipse.vorto.plugin.generator.utils.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.plugin.generator.utils.ICodeGeneratorTask;
import org.eclipse.vorto.plugin.generator.utils.IFileTemplate;
import org.eclipse.vorto.plugin.generator.utils.IGeneratedWriter;
import org.eclipse.vorto.plugin.utils.Utils;

public class EclipseHonoJavaGenerator
implements ICodeGenerator {
    public IGenerationResult generate(InformationModel model, InvocationContext context) throws GeneratorException {
        GenerationResultZip output = new GenerationResultZip(model, "hono-java");
        GenerationResultBuilder result = GenerationResultBuilder.from((IGenerationResult)output);
        result.append(this.generateJava(model, context));
        return output;
    }

    private IGenerationResult generateJava(InformationModel infomodel, InvocationContext context) {
        GenerationResultZip output = new GenerationResultZip(infomodel, "hono-java");
        ChainedCodeGeneratorTask generator = new ChainedCodeGeneratorTask();
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new PomFileTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new Log4jTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new AppTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new IDataServiceTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new HonoDataService()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new HonoMqttClientTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new InformationModelTemplate()));
        generator.generate((Object)infomodel, context, (IGeneratedWriter)output);
        for (FunctionblockProperty fbProperty : infomodel.getProperties()) {
            new GeneratorTaskFromFileTemplate((IFileTemplate)new FunctionblockTemplate(infomodel)).generate((Object)fbProperty.getType(), context, (IGeneratedWriter)output);
            FunctionBlock fb = fbProperty.getType().getFunctionblock();
            for (Entity entity : Utils.getReferencedEntities((FunctionBlock)fb)) {
                this.generateForEntity(infomodel, entity, (IGeneratedWriter)output);
            }
            for (Enum en : Utils.getReferencedEnums((FunctionBlock)fb)) {
                this.generateForEnum(infomodel, en, (IGeneratedWriter)output);
            }
        }
        return output;
    }

    private void generateForEntity(InformationModel infomodel, Entity entity, IGeneratedWriter outputter) {
        new JavaClassGeneratorTask(infomodel).generate(entity, null, outputter);
    }

    private void generateForEnum(InformationModel infomodel, Enum en, IGeneratedWriter outputter) {
        new JavaEnumGeneratorTask(infomodel).generate(en, null, outputter);
    }

    public GeneratorPluginInfo getMeta() {
        return (GeneratorPluginInfo)GeneratorPluginInfo.Builder((String)"hono-java").withVendor("Eclipse Hono Team").withName("Eclipse Hono").withDescription("Creates Java code that sends telemetry data to Hono MQTT Connector.").withDocumentationUrl("https://www.eclipse.org/hono").build();
    }
}

