/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.template.runner;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class DockerWaitForItShTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        return "wait-for-it.sh";
    }

    public String getPath(InformationModel context) {
        return "generator-parent/generator-runner/docker";
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/usr/bin/env bash");
        _builder.newLine();
        _builder.append("#   Use this script to test if a given TCP host/port are available");
        _builder.newLine();
        _builder.newLine();
        _builder.append("cmdname=$(basename $0)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("echoerr() { if [[ $QUIET -ne 1 ]]; then echo \"$@\" 1>&2; fi }");
        _builder.newLine();
        _builder.newLine();
        _builder.append("usage()");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("cat << USAGE >&2");
        _builder.newLine();
        _builder.append("Usage:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("$cmdname host:port [-s] [-t timeout] [-- command args]");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("-h HOST | --host=HOST       Host or IP under test");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("-p PORT | --port=PORT       TCP port under test");
        _builder.newLine();
        _builder.append("                                ");
        _builder.append("Alternatively, you specify the host and port as host:port");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("-s | --strict               Only execute subcommand if the test succeeds");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("-q | --quiet                Don't output any status messages");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("-t TIMEOUT | --timeout=TIMEOUT");
        _builder.newLine();
        _builder.append("                                ");
        _builder.append("Timeout in seconds, zero for no timeout");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("-- COMMAND ARGS             Execute command with args after the test finishes");
        _builder.newLine();
        _builder.append("USAGE");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("exit 1");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("wait_for()");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if [[ $TIMEOUT -gt 0 ]]; then");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("echoerr \"$cmdname: waiting $TIMEOUT seconds for $HOST:$PORT\"");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("else");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("echoerr \"$cmdname: waiting for $HOST:$PORT without a timeout\"");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("start_ts=$(date +%s)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("while :");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("do");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if [[ $ISBUSY -eq 1 ]]; then");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("nc -z $HOST $PORT");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("result=$?");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("else");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("(echo > /dev/tcp/$HOST/$PORT) >/dev/null 2>&1");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("result=$?");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if [[ $result -eq 0 ]]; then");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("end_ts=$(date +%s)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("echoerr \"$cmdname: $HOST:$PORT is available after $((end_ts - start_ts)) seconds\"");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("break");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("sleep 1");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("done");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return $result");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("wait_for_wrapper()");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# In order to support SIGINT during timeout: http://unix.stackexchange.com/a/57692");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if [[ $QUIET -eq 1 ]]; then");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("timeout $BUSYTIMEFLAG $TIMEOUT $0 --quiet --child --host=$HOST --port=$PORT --timeout=$TIMEOUT &");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("else");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("timeout $BUSYTIMEFLAG $TIMEOUT $0 --child --host=$HOST --port=$PORT --timeout=$TIMEOUT &");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("PID=$!");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("trap \"kill -INT -$PID\" INT");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("wait $PID");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("RESULT=$?");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if [[ $RESULT -ne 0 ]]; then");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("echoerr \"$cmdname: timeout occurred after waiting $TIMEOUT seconds for $HOST:$PORT\"");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return $RESULT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# process arguments");
        _builder.newLine();
        _builder.append("while [[ $# -gt 0 ]]");
        _builder.newLine();
        _builder.append("do");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("case \"$1\" in");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("*:* )");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("hostport=(${1//:/ })");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("HOST=${hostport[0]}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("PORT=${hostport[1]}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift 1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("--child)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("CHILD=1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift 1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("-q | --quiet)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("QUIET=1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift 1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("-s | --strict)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("STRICT=1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift 1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("-h)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("HOST=\"$2\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if [[ $HOST == \"\" ]]; then break; fi");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift 2");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("--host=*)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("HOST=\"${1#*=}\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift 1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("-p)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("PORT=\"$2\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if [[ $PORT == \"\" ]]; then break; fi");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift 2");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("--port=*)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("PORT=\"${1#*=}\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift 1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("-t)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("TIMEOUT=\"$2\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if [[ $TIMEOUT == \"\" ]]; then break; fi");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift 2");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("--timeout=*)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("TIMEOUT=\"${1#*=}\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift 1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("--)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("shift");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("CLI=(\"$@\")");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("break");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("--help)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("usage");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("*)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("echoerr \"Unknown argument: $1\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("usage");
        _builder.newLine();
        _builder.append("        ");
        _builder.append(";;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("esac");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.newLine();
        _builder.append("if [[ \"$HOST\" == \"\" || \"$PORT\" == \"\" ]]; then");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("echoerr \"Error: you need to provide a host and port to test.\"");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("usage");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append("TIMEOUT=${TIMEOUT:-15}");
        _builder.newLine();
        _builder.append("STRICT=${STRICT:-0}");
        _builder.newLine();
        _builder.append("CHILD=${CHILD:-0}");
        _builder.newLine();
        _builder.append("QUIET=${QUIET:-0}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# check to see if timeout is from busybox?");
        _builder.newLine();
        _builder.append("# check to see if timeout is from busybox?");
        _builder.newLine();
        _builder.append("TIMEOUT_PATH=$(realpath $(which timeout))");
        _builder.newLine();
        _builder.append("if [[ $TIMEOUT_PATH =~ \"busybox\" ]]; then");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("ISBUSY=1");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("BUSYTIMEFLAG=\"-t\"");
        _builder.newLine();
        _builder.append("else");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("ISBUSY=0");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("BUSYTIMEFLAG=\"\"");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append("if [[ $CHILD -gt 0 ]]; then");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("wait_for");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("RESULT=$?");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("exit $RESULT");
        _builder.newLine();
        _builder.append("else");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if [[ $TIMEOUT -gt 0 ]]; then");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("wait_for_wrapper");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("RESULT=$?");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("else");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("wait_for");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("RESULT=$?");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append("if [[ $CLI != \"\" ]]; then");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if [[ $RESULT -ne 0 && $STRICT -eq 1 ]]; then");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("echoerr \"$cmdname: strict mode, refusing to execute subprocess\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("exit $RESULT");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("exec \"${CLI[@]}\"");
        _builder.newLine();
        _builder.append("else");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("exit $RESULT");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        return _builder.toString();
    }
}

