/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.spi.service;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import org.eclipse.vorto.codegen.api.FileContent;
import org.eclipse.vorto.codegen.api.Generated;
import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.spi.config.AbstractGeneratorConfiguration;
import org.eclipse.vorto.codegen.spi.model.Generator;
import org.eclipse.vorto.codegen.spi.repository.GeneratorRepository;
import org.eclipse.vorto.codegen.spi.utils.GatewayUtils;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.ModelConversionUtils;
import org.eclipse.vorto.core.api.model.datatype.impl.DatatypePackageImpl;
import org.eclipse.vorto.core.api.model.functionblock.impl.FunctionblockPackageImpl;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModelFactory;
import org.eclipse.vorto.core.api.model.informationmodel.impl.InformationModelPackageImpl;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.model.ModelContent;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.conversion.ModelContentToEcoreConverter;
import org.eclipse.vorto.repository.client.IRepositoryClient;
import org.eclipse.vorto.repository.client.attachment.Attachment;
import org.eclipse.vorto.utilities.reader.IModelWorkspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class VortoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VortoService.class);
    @Autowired
    private AbstractGeneratorConfiguration env;
    @Autowired
    private GeneratorRepository repo;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private IRepositoryClient modelRepository;
    @Value(value="${server.config.generatorUser:#{null}}")
    private String generatorUsername;
    @Value(value="${server.config.generatorPassword:#{null}}")
    private String generatorPassword;
    private static final ModelContentToEcoreConverter converter = new ModelContentToEcoreConverter();

    public IGenerationResult generate(ModelContent model, String pluginkey, Map<String, String> params) {
        LOGGER.info(String.format("Generating for [%s]", model.getRoot().getPrettyFormat()));
        Model converted = converter.convert(model, Optional.empty());
        Generator generator = this.repo.get(pluginkey).orElseThrow(GatewayUtils.notFound(String.format("[Generator %s]", pluginkey)));
        InvocationContext invocationContext = InvocationContext.simpleInvocationContext(params);
        InformationModel infomodel = Utils.toInformationModel((Model)converted);
        return this.generate(generator.getInstance(), infomodel, invocationContext);
    }

    public IGenerationResult generate(String key, String namespace, String name, String version, Map<String, String> parameters, Optional<String> headerAuth) {
        LOGGER.info(String.format("Generating for Platform [%s] and Model [%s.%s:%s]", key, namespace, name, version));
        Generator generator = this.repo.get(key).orElseThrow(GatewayUtils.notFound(String.format("[Generator %s]", key)));
        InformationModel model = this.getModel(namespace, name, version, headerAuth).orElseThrow(GatewayUtils.notFound(String.format("[Model %s.%s:%s]", namespace, name, version)));
        List<MappingModel> mappings = this.getMappings(key, namespace, name, version, headerAuth);
        InvocationContext invocationContext = new InvocationContext(mappings, this.repo.newGeneratorLookup(), parameters);
        try {
            ModelId modelId = new ModelId(name, namespace, version);
            List attachments = this.modelRepository.getAttachments(modelId);
            Optional<Attachment> importedFile = attachments.stream().filter(attachment -> attachment.getTagById(Attachment.TAG_IMPORTED.getLabel()) != null).findAny();
            if (importedFile.isPresent()) {
                byte[] importedFileContent = this.modelRepository.downloadAttachment(modelId, importedFile.get().getFilename());
                invocationContext.setImportedFile(new FileContent(importedFile.get().getFilename(), importedFileContent));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.generate(generator.getInstance(), model, invocationContext);
    }

    public IGenerationResult generate(String key, Map<String, String> parameters, Optional<String> headerAuth) {
        LOGGER.info(String.format("Generating for Platform [%s]", key));
        Generator generator = this.repo.get(key).orElseThrow(GatewayUtils.notFound(String.format("[Generator %s]", key)));
        InformationModel infomodel = InformationModelFactory.eINSTANCE.createInformationModel();
        infomodel.setNamespace("com.mycompany");
        infomodel.setName("Template");
        infomodel.setVersion("0.0.1");
        InvocationContext invocationContext = InvocationContext.simpleInvocationContext(parameters);
        return this.generate(generator.getInstance(), infomodel, invocationContext);
    }

    private IGenerationResult generate(IVortoCodeGenerator generator, InformationModel model, InvocationContext invocationContext) {
        try {
            return generator.generate(ModelConversionUtils.convertToFlatHierarchy((InformationModel)model), invocationContext, null);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Exception on generating [%s.%s:%s] for key[%s]", model.getNamespace(), model.getName(), model.getVersion(), generator.getServiceKey()), (Throwable)e);
            GenerationResultZip output = new GenerationResultZip(model, generator.getServiceKey());
            Generated generated = new Generated("generation_error.log", "/generated", Throwables.getStackTraceAsString((Throwable)e));
            output.write(generated);
            return output;
        }
    }

    public Optional<InformationModel> getModel(String namespace, String name, String version, Optional<String> headerAuth) {
        Optional<byte[]> modelResources = this.downloadUrl(this.urlForModel(namespace, name, version), headerAuth);
        if (!modelResources.isPresent()) {
            return Optional.empty();
        }
        IModelWorkspace workspace = IModelWorkspace.newReader().addZip(new ZipInputStream(new ByteArrayInputStream(modelResources.get()))).read();
        return Optional.of(Utils.toInformationModel((Model)workspace.get().stream().filter(p -> p.getName().equals(name)).findFirst().get()));
    }

    private String urlForModel(String namespace, String name, String version) {
        return String.format("%s/api/v1/models/%s/file?includeDependencies=true", this.env.getVortoRepoUrl(), new ModelId(name, namespace, version).getPrettyFormat());
    }

    public List<MappingModel> getMappings(String generatorKey, String namespace, String name, String version, Optional<String> headerAuth) {
        Optional<byte[]> mappingResources = this.downloadUrl(this.urlForMapping(generatorKey, namespace, name, version), headerAuth);
        if (mappingResources.isPresent()) {
            IModelWorkspace workspace = IModelWorkspace.newReader().addZip(new ZipInputStream(new ByteArrayInputStream(mappingResources.get()))).read();
            List models = workspace.get().stream().filter(p -> p instanceof MappingModel).collect(Collectors.toList());
            return models.stream().map(MappingModel.class::cast).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String urlForMapping(String targetPlatform, String namespace, String name, String version) {
        return String.format("%s/rest/models/%s/download/mappings/%s", this.env.getVortoRepoUrl(), new ModelId(name, namespace, version).getPrettyFormat(), targetPlatform);
    }

    private Optional<byte[]> downloadUrl(String url, Optional<String> headerAuth) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Downloading " + url);
            }
            HttpEntity entity = headerAuth.map(token -> {
                HttpHeaders headers = new HttpHeaders();
                headers.add("Authorization", token);
                return new HttpEntity((Object)"parameters", (MultiValueMap)headers);
            }).orElse(null);
            return Optional.of(this.restTemplate.exchange(url, HttpMethod.GET, entity, byte[].class, new Object[0]).getBody());
        }
        catch (RestClientException e) {
            LOGGER.error("Error downloading the URL [" + url + "]", (Throwable)e);
            return Optional.empty();
        }
    }

    @PostConstruct
    public void init() {
        DatatypePackageImpl.init();
        FunctionblockPackageImpl.init();
        InformationModelPackageImpl.init();
    }
}

